/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.impl.TagWriterImpl;
import org.wildfly.clustering.marshalling.protostream.EnumMarshaller;
import org.wildfly.clustering.marshalling.protostream.NativeSerializationContext;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;

public class DefaultSerializationContext
extends NativeSerializationContext
implements SerializationContext {
    private final org.infinispan.protostream.SerializationContext context;

    public DefaultSerializationContext(org.infinispan.protostream.SerializationContext context) {
        super(context);
        this.context = context;
    }

    @Override
    public <T> ProtoStreamMarshaller<T> getMarshaller(T object) {
        return (ProtoStreamMarshaller)this.context.getMarshaller(object);
    }

    @Override
    public <T> ProtoStreamMarshaller<T> getMarshaller(String fullTypeName) {
        return (ProtoStreamMarshaller)this.context.getMarshaller(fullTypeName);
    }

    @Override
    public <T> ProtoStreamMarshaller<T> getMarshaller(Class<T> clazz) {
        return (ProtoStreamMarshaller)this.context.getMarshaller(clazz);
    }

    @Override
    public void registerMarshaller(ProtoStreamMarshaller<?> marshaller) {
        this.context.registerMarshaller(marshaller);
    }

    @Override
    public void registerMarshaller(final BaseMarshaller<?> marshaller) {
        if (marshaller instanceof ProtoStreamMarshaller) {
            ProtoStreamMarshaller protostreamMarshaller = (ProtoStreamMarshaller)marshaller;
            this.registerMarshaller(protostreamMarshaller);
        } else if (marshaller instanceof ProtobufTagMarshaller) {
            final ProtobufTagMarshaller nativeMarshaller = (ProtobufTagMarshaller)marshaller;
            this.registerMarshaller(new ProtoStreamMarshaller<Object>(){

                @Override
                public Class<? extends Object> getJavaClass() {
                    return nativeMarshaller.getJavaClass();
                }

                @Override
                public String getTypeName() {
                    return nativeMarshaller.getTypeName();
                }

                @Override
                public Object readFrom(ProtoStreamReader reader) throws IOException {
                    return this.read((ProtobufTagMarshaller.ReadContext)reader);
                }

                @Override
                public void writeTo(ProtoStreamWriter writer, Object value) throws IOException {
                    this.write((ProtobufTagMarshaller.WriteContext)((TagWriterImpl)((ProtobufTagMarshaller.WriteContext)writer).getWriter()), value);
                }

                @Override
                public Object read(ProtobufTagMarshaller.ReadContext context) throws IOException {
                    return nativeMarshaller.read(context);
                }

                @Override
                public void write(ProtobufTagMarshaller.WriteContext context, Object value) throws IOException {
                    nativeMarshaller.write(context, value);
                }
            });
        } else if (marshaller instanceof org.infinispan.protostream.EnumMarshaller) {
            this.registerMarshaller(new EnumMarshaller(marshaller.getJavaClass()){

                @Override
                public String getTypeName() {
                    return marshaller.getTypeName();
                }
            });
        } else {
            throw new IllegalArgumentException(marshaller.getTypeName());
        }
    }

    @Override
    public void registerMarshallerProvider(SerializationContext.InstanceMarshallerProvider<?> provider) {
        if (!(provider instanceof SerializationContext.InstanceMarshallerProvider)) {
            throw new IllegalArgumentException();
        }
        this.context.registerMarshallerProvider(provider);
    }

    @Override
    public void unregisterMarshallerProvider(SerializationContext.InstanceMarshallerProvider<?> provider) {
        if (!(provider instanceof SerializationContext.InstanceMarshallerProvider)) {
            throw new IllegalArgumentException();
        }
        this.context.unregisterMarshallerProvider(provider);
    }

    @Override
    public ImmutableSerializationContext getImmutableSerializationContext() {
        return this.context;
    }
}

