/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.securitymanager.SystemSecurityManager;

public class HibernateMethodLookupDispatcher {
    private static final int MIN_STACK_FRAMES = 3;
    private static final int MAX_STACK_FRAMES = 16;
    private static final PrivilegedAction<Class<?>[]> GET_CALLER_STACK_ACTION;
    private static Set<String> authorizedClasses;

    public static Method getDeclaredMethod(final Class<?> type, final String name, final Class<?>[] parameters) {
        PrivilegedAction<Method> getDeclaredMethodAction = new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return type.getDeclaredMethod(name, parameters);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    return null;
                }
            }
        };
        return HibernateMethodLookupDispatcher.doPrivilegedAction(getDeclaredMethodAction);
    }

    public static Method getMethod(final Class<?> type, final String name, final Class<?>[] parameters) {
        PrivilegedAction<Method> getMethodAction = new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return type.getMethod(name, parameters);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    return null;
                }
            }
        };
        return HibernateMethodLookupDispatcher.doPrivilegedAction(getMethodAction);
    }

    private static Method doPrivilegedAction(PrivilegedAction<Method> privilegedAction) {
        Class<?> callerClass = HibernateMethodLookupDispatcher.getCallerClass();
        if (!authorizedClasses.contains(callerClass.getName())) {
            throw new SecurityException("Unauthorized call by class " + String.valueOf(callerClass));
        }
        return SystemSecurityManager.isSecurityManagerEnabled() ? AccessController.doPrivileged(privilegedAction) : privilegedAction.run();
    }

    static void registerAuthorizedClass(String className) {
        authorizedClasses.add(className);
    }

    private static Class<?> getCallerClass() {
        Class<?>[] stackTrace;
        Class<?>[] classArray = stackTrace = SystemSecurityManager.isSecurityManagerEnabled() ? AccessController.doPrivileged(GET_CALLER_STACK_ACTION) : GET_CALLER_STACK_ACTION.run();
        if (stackTrace.length <= 3) {
            throw new SecurityException("Unable to determine the caller class");
        }
        boolean hibernateMethodLookupDispatcherDetected = false;
        int maxFrames = Math.min(16, stackTrace.length);
        for (int i = 3; i < maxFrames; ++i) {
            if (stackTrace[i].getName().equals(HibernateMethodLookupDispatcher.class.getName())) {
                hibernateMethodLookupDispatcherDetected = true;
                continue;
            }
            if (!hibernateMethodLookupDispatcherDetected) continue;
            return stackTrace[i];
        }
        throw new SecurityException("Unable to determine the caller class");
    }

    static {
        authorizedClasses = ConcurrentHashMap.newKeySet();
        PrivilegedAction<PrivilegedAction<Class<?>[]>> initializeGetCallerStackAction = new PrivilegedAction<PrivilegedAction<Class<?>[]>>(){

            @Override
            public PrivilegedAction<Class<?>[]> run() {
                try {
                    return new StackWalkerGetCallerStackAction(StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
                }
                catch (Throwable e) {
                    throw new HibernateException("Unable to initialize the stack walker", e);
                }
            }
        };
        GET_CALLER_STACK_ACTION = SystemSecurityManager.isSecurityManagerEnabled() ? AccessController.doPrivileged(initializeGetCallerStackAction) : (PrivilegedAction)initializeGetCallerStackAction.run();
    }

    private static class StackWalkerGetCallerStackAction
    implements PrivilegedAction<Class<?>[]> {
        private final StackWalker stackWalker;
        private final Function<Stream<StackWalker.StackFrame>, Class<?>[]> stackFrameExtractFunction = new Function<Stream<StackWalker.StackFrame>, Class<?>[]>(){

            @Override
            public Class<?>[] apply(Stream<StackWalker.StackFrame> stream) {
                return (Class[])stream.map(stackFrameGetDeclaringClassFunction).limit(16L).toArray(Class[]::new);
            }
        };
        private final Function<StackWalker.StackFrame, Class<?>> stackFrameGetDeclaringClassFunction = new Function<StackWalker.StackFrame, Class<?>>(){

            @Override
            public Class<?> apply(StackWalker.StackFrame frame) {
                try {
                    return frame.getDeclaringClass();
                }
                catch (RuntimeException e) {
                    throw new HibernateException("Unable to get stack frame declaring class", e);
                }
            }
        };

        StackWalkerGetCallerStackAction(StackWalker stackWalker) {
            this.stackWalker = stackWalker;
        }

        @Override
        public Class<?>[] run() {
            try {
                return this.stackWalker.walk(this.stackFrameExtractFunction);
            }
            catch (RuntimeException e) {
                throw new SecurityException("Unable to determine the caller class", e);
            }
        }
    }
}

