/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.utils;

import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.spi.config.SimpleServiceConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorkConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(StorkConfigUtils.class);
    private static final String CONFIG_PROPERTY_PART_EXPRESSION = "\".*\"|[^.]+";
    private static final Pattern CONFIG_PROP_PART = Pattern.compile("\".*\"|[^.]+");
    public static final String LOAD_BALANCER = "load-balancer";
    public static final String LOAD_BALANCER_EMBEDDED = "load-balancer.type";
    public static final String SERVICE_DISCOVERY = "service-discovery";
    public static final String SERVICE_DISCOVERY_EMBEDDED = "service-discovery.type";
    public static final String SERVICE_REGISTRAR = "service-registrar";
    public static final String SERVICE_REGISTRAR_EMBEDDED = "service-registrar.type";

    public static void computeServiceProperty(Map<String, Map<String, String>> propertiesByServiceName, String propertyName, String propertyValue) {
        Matcher matcher = CONFIG_PROP_PART.matcher(propertyName);
        if (!matcher.find()) {
            return;
        }
        if ("stork".equals(matcher.group())) {
            if (!matcher.find()) {
                log.warn("Potentially invalid property for SmallRye Stork: " + propertyName);
            }
            String serviceName = StorkConfigUtils.unwrapFromQuotes(matcher.group());
            int serviceNameEndIdx = matcher.end();
            if (!matcher.find()) {
                log.warn("Potentially invalid property for SmallRye Stork: " + propertyName);
            }
            Map serviceProperties = propertiesByServiceName.computeIfAbsent(serviceName, ignored -> new HashMap());
            String serviceProperty = StorkConfigUtils.propertyKey(propertyName.substring(serviceNameEndIdx));
            serviceProperties.put(serviceProperty, propertyValue);
        }
    }

    public static SimpleServiceConfig buildServiceConfig(Map.Entry<String, Map<String, String>> serviceEntry) {
        String serviceRegistrarType;
        String serviceDiscoveryType;
        SimpleServiceConfig.Builder builder = new SimpleServiceConfig.Builder();
        Map<String, String> properties = serviceEntry.getValue();
        String serviceName = serviceEntry.getKey();
        String loadBalancerType = properties.get(LOAD_BALANCER);
        if (loadBalancerType == null) {
            loadBalancerType = properties.get(LOAD_BALANCER_EMBEDDED);
        }
        builder.setServiceName(serviceName);
        if (loadBalancerType != null) {
            SimpleServiceConfig.SimpleLoadBalancerConfig loadBalancerConfig = new SimpleServiceConfig.SimpleLoadBalancerConfig(loadBalancerType, StorkConfigUtils.propertiesForPrefix(LOAD_BALANCER, properties));
            builder = builder.setLoadBalancer((ConfigWithType)loadBalancerConfig);
        }
        if ((serviceDiscoveryType = properties.get(SERVICE_DISCOVERY)) == null) {
            serviceDiscoveryType = properties.get(SERVICE_DISCOVERY_EMBEDDED);
        }
        if (serviceDiscoveryType != null) {
            SimpleServiceConfig.SimpleServiceDiscoveryConfig serviceDiscoveryConfig = new SimpleServiceConfig.SimpleServiceDiscoveryConfig(serviceDiscoveryType, StorkConfigUtils.propertiesForPrefix(SERVICE_DISCOVERY, properties));
            builder = builder.setServiceDiscovery((ConfigWithType)serviceDiscoveryConfig);
        }
        if ((serviceRegistrarType = properties.get(SERVICE_REGISTRAR)) == null) {
            serviceRegistrarType = properties.get(SERVICE_REGISTRAR_EMBEDDED);
        }
        if (serviceRegistrarType != null) {
            SimpleServiceConfig.SimpleServiceRegistrarConfig serviceRegistrarConfig = new SimpleServiceConfig.SimpleServiceRegistrarConfig(serviceRegistrarType, StorkConfigUtils.propertiesForPrefix(SERVICE_REGISTRAR, properties));
            builder = builder.setServiceRegistrar((ConfigWithType)serviceRegistrarConfig);
        }
        return builder.build();
    }

    public static String unwrapFromQuotes(String text) {
        if (text.length() < 2) {
            return text;
        }
        if (text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String propertyKey(String text) {
        if (!text.isEmpty() && text.charAt(0) == '.') {
            return text.substring(1);
        }
        return text;
    }

    public static Map<String, String> propertiesForPrefix(String prefix, Map<String, String> original) {
        prefix = ((String)prefix).endsWith(".") ? prefix : (String)prefix + ".";
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : original.entrySet()) {
            String propertyName = entry.getKey();
            if (!propertyName.startsWith((String)prefix)) continue;
            String nameWithoutPrefix = propertyName.substring(((String)prefix).length());
            result.put(nameWithoutPrefix, entry.getValue());
        }
        return result;
    }
}

