/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.server.util.BlockingReference;
import org.wildfly.clustering.server.util.Reference;

public interface BlockingReferenceMap<K, V>
extends Reference<Map<K, V>> {
    public BlockingReference<V> reference(K var1);

    public static <K, V> BlockingReferenceMap<K, V> of(final Map<K, V> map) {
        final StampedLock lock = new StampedLock();
        final Supplier<Map> reader = () -> Collections.unmodifiableMap(map);
        final UnaryOperator mapper = UnaryOperator.identity();
        return new BlockingReferenceMap<K, V>(){

            @Override
            public BlockingReference<V> reference(K key) {
                final Supplier<Object> reader2 = () -> map.get(key);
                final Consumer<Object> writer = value -> map.put(key, value);
                final UnaryOperator mapper2 = UnaryOperator.identity();
                return new BlockingReference<V>(){

                    @Override
                    public Reference.Reader<V> reader() {
                        return new Reference.ReferenceReader(lock, reader2, mapper2);
                    }

                    @Override
                    public BlockingReference.Writer<V> writer(UnaryOperator<V> updater) {
                        return new BlockingReference.ReferenceWriter(lock, reader2, writer, mapper2, updater);
                    }
                };
            }

            @Override
            public Reference.Reader<Map<K, V>> reader() {
                return new Reference.ReferenceReader(lock, reader, mapper);
            }
        };
    }
}

