/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.BinaryServiceDescriptorFactory;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.ConfigurationResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;

public class BackupSitesResourceDefinitionRegistrar
extends ConfigurationResourceDefinitionRegistrar<SitesConfiguration, SitesConfigurationBuilder> {
    static final BinaryServiceDescriptor<SitesConfiguration> SERVICE_DESCRIPTOR = BinaryServiceDescriptorFactory.createServiceDescriptor(ComponentResourceRegistration.BACKUP_SITES, SitesConfiguration.class);
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.GRANDPARENT_PARENT).setAllowMultipleRegistrations(true).build();
    private final FunctionExecutorRegistry<Cache<?, ?>> executors;

    public BackupSitesResourceDefinitionRegistrar(FunctionExecutorRegistry<Cache<?, ?>> executors) {
        super(new ConfigurationResourceDefinitionRegistrar.Configurator<SitesConfiguration>(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return ComponentResourceRegistration.BACKUP_SITES;
            }

            @Override
            public RuntimeCapability<Void> getCapability() {
                return CAPABILITY;
            }
        });
        this.executors = executors;
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = super.register(parent, context);
        new BackupSiteResourceDefinitionRegistrar(this.get(), this.executors).register(registration, context);
        return registration;
    }

    public ServiceDependency<SitesConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = context.getCurrentAddress().getParent();
        PathAddress containerAddress = cacheAddress.getParent();
        String containerName = containerAddress.getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Set sites = resource.getChildrenNames(BackupSiteResourceDefinitionRegistrar.REGISTRATION.getPathElement().getKey());
        final ArrayList<ServiceDependency> backups = new ArrayList<ServiceDependency>(sites.size());
        for (String site : sites) {
            backups.add(ServiceDependency.on(BackupSiteResourceDefinitionRegistrar.SERVICE_DESCRIPTOR, (String)containerName, (String)cacheName, (String)site));
        }
        return new ServiceDependency<SitesConfigurationBuilder>(){

            public void accept(RequirementServiceBuilder<?> builder) {
                for (ServiceDependency backup : backups) {
                    backup.accept(builder);
                }
            }

            public SitesConfigurationBuilder get() {
                SitesConfigurationBuilder builder = new ConfigurationBuilder().sites();
                for (ServiceDependency backup : backups) {
                    builder.addBackup().read((Object)((BackupConfiguration)backup.get()));
                }
                return builder;
            }
        };
    }
}

