/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.jboss.as.clustering.controller.ModuleListAttributeDefinition;
import org.jboss.as.clustering.controller.StatisticsEnabledAttributeDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.HeapMemoryResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.HotRodStoreResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanCacheBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.LazyCacheServiceInstaller;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.MemoryResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.MemoryResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.NoStoreResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.OffHeapMemoryResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.PersistenceResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinitionRegistrar;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemModel;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.wildfly.clustering.infinispan.service.CacheConfigurationServiceInstaller;
import org.wildfly.clustering.infinispan.service.CacheServiceInstaller;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteredCacheServiceInstallerProvider;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.LegacyClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.LocalCacheServiceInstallerProvider;
import org.wildfly.clustering.server.service.ProvidedBinaryServiceInstallerProvider;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceConfiguratorFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceTargetFactory;
import org.wildfly.service.Dependency;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReference;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class CacheResourceDefinitionRegistrar
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator,
ResourceModelResolver<ServiceDependency<ConfigurationBuilder>>,
UnaryOperator<ResourceDescriptor.Builder> {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONFIGURATION).setAllowMultipleRegistrations(true).build();
    static final BinaryServiceDescriptor<ClassLoader> CLASS_LOADER = BinaryServiceDescriptor.of((String)(InfinispanServiceDescriptor.CACHE_CONFIGURATION.getName() + ".loader"), ClassLoader.class);
    static final ResourceCapabilityReference<GlobalConfiguration> CACHE_CONTAINER_CONFIGURATION = ResourceCapabilityReference.builder(CAPABILITY, (UnaryServiceDescriptor)InfinispanServiceDescriptor.CACHE_CONTAINER_CONFIGURATION).withRequirementNameResolver((Function)UnaryCapabilityNameResolver.PARENT).build();
    static final StatisticsEnabledAttributeDefinition STATISTICS_ENABLED = new StatisticsEnabledAttributeDefinition.Builder().build();
    static final ModuleListAttributeDefinition MODULES = ((ModuleListAttributeDefinition.Builder)new ModuleListAttributeDefinition.Builder().setRequired(false)).build();
    private final CacheResourceRegistration registration;

    public CacheResourceDefinitionRegistrar(CacheResourceRegistration registration) {
        this.registration = registration;
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        RuntimeCapability cache = RuntimeCapability.Builder.of((BinaryServiceDescriptor)InfinispanServiceDescriptor.CACHE).setAllowMultipleRegistrations(true).build();
        RuntimeCapability registryFactory = RuntimeCapability.Builder.of((BinaryServiceDescriptor)ClusteringServiceDescriptor.REGISTRY_FACTORY).build();
        RuntimeCapability legacyRegistryFactory = RuntimeCapability.Builder.of((BinaryServiceDescriptor)LegacyClusteringServiceDescriptor.REGISTRY_FACTORY).build();
        RuntimeCapability serviceProviderRegistrar = RuntimeCapability.Builder.of((BinaryServiceDescriptor)ClusteringServiceDescriptor.SERVICE_PROVIDER_REGISTRAR).build();
        RuntimeCapability legacyServiceProviderRegistry = RuntimeCapability.Builder.of((BinaryServiceDescriptor)LegacyClusteringServiceDescriptor.SERVICE_PROVIDER_REGISTRY).build();
        RuntimeCapability singletonServiceTargetFactory = RuntimeCapability.Builder.of((BinaryServiceDescriptor)SingletonServiceTargetFactory.SERVICE_DESCRIPTOR).build();
        RuntimeCapability singletonServiceConfiguratorFactory = RuntimeCapability.Builder.of((BinaryServiceDescriptor)SingletonServiceConfiguratorFactory.SERVICE_DESCRIPTOR).build();
        RuntimeCapability singletonServiceBuilderFactory = RuntimeCapability.Builder.of((BinaryServiceDescriptor)SingletonServiceBuilderFactory.SERVICE_DESCRIPTOR).build();
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)builder.addAttributes(List.of(STATISTICS_ENABLED, MODULES))).addCapabilities(List.of(CAPABILITY, cache, registryFactory, legacyRegistryFactory, serviceProviderRegistrar, legacyServiceProviderRegistry, singletonServiceTargetFactory, singletonServiceConfiguratorFactory, singletonServiceBuilderFactory))).addResourceCapabilityReference(CACHE_CONTAINER_CONFIGURATION)).requireChildResources(Set.of(ComponentResourceRegistration.EXPIRATION, ComponentResourceRegistration.LOCKING, ComponentResourceRegistration.TRANSACTION))).requireSingletonChildResources(Set.of(MemoryResourceRegistration.HEAP, StoreResourceRegistration.NONE))).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ParentResourceDescriptionResolver resolver = InfinispanSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(this.registration.getPathElement(), PathElement.pathElement((String)"cache"));
        ResourceDescriptor descriptor = this.apply(ResourceDescriptor.builder((ResourceDescriptionResolver)resolver)).build();
        ManagementResourceRegistration registration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)this.registration, (ResourceDescriptionResolver)resolver, (SubsystemModel)this.registration.getDeprecation()).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        new HeapMemoryResourceDefinitionRegistrar().register(registration, context);
        new OffHeapMemoryResourceDefinitionRegistrar().register(registration, context);
        new ExpirationResourceDefinitionRegistrar().register(registration, context);
        new LockingResourceDefinitionRegistrar().register(registration, context);
        new TransactionResourceDefinitionRegistrar().register(registration, context);
        new NoStoreResourceDefinitionRegistrar().register(registration, context);
        new CustomStoreResourceDefinitionRegistrar().register(registration, context);
        new FileStoreResourceDefinitionRegistrar().register(registration, context);
        new JDBCStoreResourceDefinitionRegistrar().register(registration, context);
        new RemoteStoreResourceDefinitionRegistrar().register(registration, context);
        new HotRodStoreResourceDefinitionRegistrar().register(registration, context);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        BinaryServiceConfiguration config = BinaryServiceConfiguration.of((String)address.getParent().getLastElement().getValue(), (String)address.getLastElement().getValue());
        LinkedList<Object> installers = new LinkedList<Object>();
        installers.add(new CacheConfigurationServiceInstaller(config, this.resolve(context, model)));
        installers.add(new CacheServiceInstaller(config));
        installers.add(new LazyCacheServiceInstaller(config));
        ServiceDependency loader = MODULES.resolve(context, model).combine((Dependency)CACHE_CONTAINER_CONFIGURATION.resolve(context, model), (BiFunction)new BiFunction<List<Module>, GlobalConfiguration, ClassLoader>(){

            @Override
            public ClassLoader apply(List<Module> modules, GlobalConfiguration global) {
                if (modules.isEmpty()) {
                    return global.classLoader();
                }
                if (modules.size() == 1) {
                    return modules.get(0).getClassLoader();
                }
                return new AggregatedClassLoader((Collection)modules.stream().map(Module::getClassLoader).collect(Collectors.toUnmodifiableList()));
            }
        });
        installers.add((ResourceServiceInstaller)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)loader).provides(config.resolveServiceName(CLASS_LOADER))).build());
        installers.add(new BinderServiceInstaller(InfinispanCacheBindingFactory.CACHE.apply(config), config.resolveServiceName(LazyCacheServiceInstaller.SERVICE_DESCRIPTOR)));
        installers.add(new BinderServiceInstaller(InfinispanCacheBindingFactory.CACHE_CONFIGURATION.apply(config), config.resolveServiceName(InfinispanServiceDescriptor.CACHE_CONFIGURATION)));
        Class providerClass = this.registration.getCacheMode().isClustered() ? ClusteredCacheServiceInstallerProvider.class : LocalCacheServiceInstallerProvider.class;
        new ProvidedBinaryServiceInstallerProvider(providerClass, providerClass.getClassLoader()).apply(config).forEach(installers::add);
        return ResourceServiceInstaller.combine(installers);
    }

    public ServiceDependency<ConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        BinaryServiceConfiguration config = BinaryServiceConfiguration.of((String)address.getParent().getLastElement().getValue(), (String)address.getLastElement().getValue());
        final CacheMode mode = this.registration.getCacheMode();
        final boolean statisticsEnabled = STATISTICS_ENABLED.resolve(context, model);
        final ServiceDependency expiration = config.getServiceDependency(ExpirationResourceDefinitionRegistrar.SERVICE_DESCRIPTOR);
        final ServiceDependency memory = config.getServiceDependency(MemoryResourceDefinitionRegistrar.SERVICE_DESCRIPTOR);
        final ServiceDependency locking = config.getServiceDependency(LockingResourceDefinitionRegistrar.SERVICE_DESCRIPTOR);
        final ServiceDependency persistence = config.getServiceDependency(PersistenceResourceDefinitionRegistrar.SERVICE_DESCRIPTOR);
        final ServiceDependency transaction = config.getServiceDependency(TransactionResourceDefinitionRegistrar.SERVICE_DESCRIPTOR);
        return new ServiceDependency<ConfigurationBuilder>(){

            public void accept(RequirementServiceBuilder<?> builder) {
                memory.accept(builder);
                expiration.accept(builder);
                locking.accept(builder);
                transaction.accept(builder);
                persistence.accept(builder);
            }

            public ConfigurationBuilder get() {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.clustering().cacheMode(mode);
                builder.memory().read((Object)((MemoryConfiguration)memory.get()));
                builder.expiration().read((Object)((ExpirationConfiguration)expiration.get()));
                builder.locking().read((Object)((LockingConfiguration)locking.get()));
                builder.persistence().read((Object)((PersistenceConfiguration)persistence.get()));
                builder.transaction().read((Object)((TransactionConfiguration)transaction.get()));
                builder.statistics().enabled(statisticsEnabled);
                try {
                    TransactionConfigurationBuilder tx = builder.transaction();
                    builder.invocationBatching().enable(tx.transactionMode().isTransactional() && tx.transactionManagerLookup().getTransactionManager() == EmbeddedTransactionManager.getInstance());
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
                return builder;
            }
        };
    }
}

