/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.CdiLogger;
import io.smallrye.faulttolerance.CdiSpi;
import io.smallrye.faulttolerance.CircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.DefaultAsyncExecutorProvider;
import io.smallrye.faulttolerance.DefaultBeforeRetryHandlerProvider;
import io.smallrye.faulttolerance.DefaultExistingCircuitBreakerNames;
import io.smallrye.faulttolerance.DefaultFallbackHandlerProvider;
import io.smallrye.faulttolerance.DefaultFaultToleranceOperationProvider;
import io.smallrye.faulttolerance.Enablement;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.FaultToleranceBinding;
import io.smallrye.faulttolerance.FaultToleranceInterceptor;
import io.smallrye.faulttolerance.RequestContextIntegration;
import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.api.ApplyGuard;
import io.smallrye.faulttolerance.api.AsynchronousNonBlocking;
import io.smallrye.faulttolerance.api.BeforeRetry;
import io.smallrye.faulttolerance.api.CustomBackoff;
import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.api.Guard;
import io.smallrye.faulttolerance.api.RateLimit;
import io.smallrye.faulttolerance.api.RetryWhen;
import io.smallrye.faulttolerance.api.TypedGuard;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.config.FaultToleranceMethods;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.internal.StrategyCache;
import io.smallrye.faulttolerance.metrics.CompoundMetricsProvider;
import io.smallrye.faulttolerance.metrics.MetricsIntegration;
import io.smallrye.faulttolerance.metrics.MicroProfileMetricsProvider;
import io.smallrye.faulttolerance.metrics.MicrometerProvider;
import io.smallrye.faulttolerance.metrics.NoopProvider;
import io.smallrye.faulttolerance.metrics.OpenTelemetryProvider;
import jakarta.annotation.Priority;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.util.AnnotationLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class FaultToleranceExtension
implements Extension {
    private static final List<Class<? extends Annotation>> BACKOFF_ANNOTATIONS = Arrays.asList(ExponentialBackoff.class, FibonacciBackoff.class, CustomBackoff.class);
    private final ConcurrentMap<String, FaultToleranceOperation> faultToleranceOperations = new ConcurrentHashMap<String, FaultToleranceOperation>();
    private final ConcurrentMap<String, Set<String>> existingCircuitBreakerNames = new ConcurrentHashMap<String, Set<String>>();
    private final ConcurrentMap<String, Set<String>> existingGuards = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> expectedGuards = ConcurrentHashMap.newKeySet();
    private final Set<MetricsIntegration> metricsIntegrations;

    private static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private static Set<MetricsIntegration> allPresentMetrics() {
        EnumSet<MetricsIntegration> result = EnumSet.noneOf(MetricsIntegration.class);
        if (FaultToleranceExtension.isPresent("org.eclipse.microprofile.metrics.MetricRegistry")) {
            result.add(MetricsIntegration.MICROPROFILE_METRICS);
        }
        if (FaultToleranceExtension.isPresent("io.opentelemetry.api.metrics.Meter")) {
            result.add(MetricsIntegration.OPENTELEMETRY);
        }
        if (FaultToleranceExtension.isPresent("io.micrometer.core.instrument.MeterRegistry")) {
            result.add(MetricsIntegration.MICROMETER);
        }
        if (result.isEmpty()) {
            result.add(MetricsIntegration.NOOP);
        }
        return result;
    }

    public FaultToleranceExtension() {
        this(FaultToleranceExtension.allPresentMetrics());
    }

    public FaultToleranceExtension(MetricsIntegration metricsIntegration) {
        this(EnumSet.of(metricsIntegration));
    }

    public FaultToleranceExtension(Set<MetricsIntegration> metricsIntegrations) {
        this.metricsIntegrations = EnumSet.copyOf(metricsIntegrations);
    }

    void registerInterceptorBindings(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        CdiLogger.LOG.activated(FaultToleranceExtension.getImplementationVersion().orElse("unknown"));
        bbd.addInterceptorBinding(new FTInterceptorBindingAnnotatedType(bm.createAnnotatedType(ApplyFaultTolerance.class)));
        bbd.addInterceptorBinding(new FTInterceptorBindingAnnotatedType(bm.createAnnotatedType(ApplyGuard.class)));
        bbd.addInterceptorBinding(new FTInterceptorBindingAnnotatedType(bm.createAnnotatedType(Asynchronous.class)));
        bbd.addInterceptorBinding(new FTInterceptorBindingAnnotatedType(bm.createAnnotatedType(AsynchronousNonBlocking.class)));
        bbd.addInterceptorBinding(new FTInterceptorBindingAnnotatedType(bm.createAnnotatedType(Bulkhead.class)));
        bbd.addInterceptorBinding(new FTInterceptorBindingAnnotatedType(bm.createAnnotatedType(CircuitBreaker.class)));
        bbd.addInterceptorBinding(new FTInterceptorBindingAnnotatedType(bm.createAnnotatedType(Fallback.class)));
        bbd.addInterceptorBinding(new FTInterceptorBindingAnnotatedType(bm.createAnnotatedType(RateLimit.class)));
        bbd.addInterceptorBinding(new FTInterceptorBindingAnnotatedType(bm.createAnnotatedType(Retry.class)));
        bbd.addInterceptorBinding(new FTInterceptorBindingAnnotatedType(bm.createAnnotatedType(Timeout.class)));
        bbd.addAnnotatedType(bm.createAnnotatedType(FaultToleranceInterceptor.class), FaultToleranceInterceptor.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(DefaultFallbackHandlerProvider.class), DefaultFallbackHandlerProvider.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(DefaultBeforeRetryHandlerProvider.class), DefaultBeforeRetryHandlerProvider.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(DefaultAsyncExecutorProvider.class), DefaultAsyncExecutorProvider.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(ExecutorHolder.class), ExecutorHolder.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(DefaultFaultToleranceOperationProvider.class), DefaultFaultToleranceOperationProvider.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(DefaultExistingCircuitBreakerNames.class), DefaultExistingCircuitBreakerNames.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(StrategyCache.class), StrategyCache.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(CircuitBreakerMaintenanceImpl.class), CircuitBreakerMaintenanceImpl.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(RequestContextIntegration.class), RequestContextIntegration.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(SpecCompatibility.class), SpecCompatibility.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(Enablement.class), Enablement.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(CdiSpi.EagerDependencies.class), CdiSpi.EagerDependencies.class.getName());
        bbd.addAnnotatedType(bm.createAnnotatedType(CdiSpi.LazyDependencies.class), CdiSpi.LazyDependencies.class.getName());
        if (this.metricsIntegrations.size() > 1) {
            bbd.addAnnotatedType(bm.createAnnotatedType(CompoundMetricsProvider.class), CompoundMetricsProvider.class.getName());
        }
        for (MetricsIntegration metricsIntegration : this.metricsIntegrations) {
            switch (metricsIntegration) {
                case MICROPROFILE_METRICS: {
                    bbd.addAnnotatedType(bm.createAnnotatedType(MicroProfileMetricsProvider.class), MicroProfileMetricsProvider.class.getName());
                    break;
                }
                case OPENTELEMETRY: {
                    bbd.addAnnotatedType(bm.createAnnotatedType(OpenTelemetryProvider.class), OpenTelemetryProvider.class.getName());
                    break;
                }
                case MICROMETER: {
                    bbd.addAnnotatedType(bm.createAnnotatedType(MicrometerProvider.class), MicrometerProvider.class.getName());
                    break;
                }
                case NOOP: {
                    bbd.addAnnotatedType(bm.createAnnotatedType(NoopProvider.class), NoopProvider.class.getName());
                }
            }
        }
    }

    void changeInterceptorPriority(@Observes ProcessAnnotatedType<FaultToleranceInterceptor> event) {
        ConfigProvider.getConfig().getOptionalValue("mp.fault.tolerance.interceptor.priority", Integer.class).ifPresent(configuredInterceptorPriority -> event.configureAnnotatedType().remove(ann -> ann instanceof Priority).add((Annotation)((Object)new PriorityLiteral((int)configuredInterceptorPriority))));
    }

    void collectFaultToleranceOperations(@Observes ProcessManagedBean<?> event) {
        AnnotatedType annotatedType = event.getAnnotatedBeanClass();
        for (AnnotatedMethod annotatedMethod : annotatedType.getMethods()) {
            FaultToleranceMethod method;
            if (annotatedMethod.getJavaMember().isSynthetic() || !(method = FaultToleranceMethods.create(annotatedType.getJavaClass(), annotatedMethod)).isLegitimate()) continue;
            FaultToleranceOperation operation = new FaultToleranceOperation(method);
            operation.validate();
            CdiLogger.LOG.debugf("Found %s", (Object)operation);
            this.faultToleranceOperations.put(FaultToleranceExtension.getCacheKey(annotatedType.getJavaClass(), annotatedMethod.getJavaMember()), operation);
            if (operation.hasCircuitBreaker() && operation.hasCircuitBreakerName()) {
                this.existingCircuitBreakerNames.computeIfAbsent(operation.getCircuitBreakerName().value(), ignored -> new HashSet()).add(annotatedMethod.getJavaMember().toGenericString());
            }
            if (operation.hasApplyGuard()) {
                this.expectedGuards.add(operation.getApplyGuard().value());
            }
            for (Class<? extends Annotation> backoffAnnotation : BACKOFF_ANNOTATIONS) {
                if (annotatedMethod.isAnnotationPresent(backoffAnnotation) && !annotatedMethod.isAnnotationPresent(Retry.class)) {
                    event.addDefinitionError((Throwable)CdiLogger.LOG.backoffAnnotationWithoutRetry(backoffAnnotation.getSimpleName(), method.method));
                }
                if (!annotatedType.isAnnotationPresent(backoffAnnotation) || annotatedType.isAnnotationPresent(Retry.class)) continue;
                event.addDefinitionError((Throwable)CdiLogger.LOG.backoffAnnotationWithoutRetry(backoffAnnotation.getSimpleName(), annotatedType.getJavaClass()));
            }
            if (annotatedMethod.isAnnotationPresent(RetryWhen.class) && !annotatedMethod.isAnnotationPresent(Retry.class)) {
                event.addDefinitionError((Throwable)CdiLogger.LOG.retryWhenAnnotationWithoutRetry(method.method));
            }
            if (annotatedType.isAnnotationPresent(RetryWhen.class) && !annotatedType.isAnnotationPresent(Retry.class)) {
                event.addDefinitionError((Throwable)CdiLogger.LOG.retryWhenAnnotationWithoutRetry(annotatedType.getJavaClass()));
            }
            if (annotatedMethod.isAnnotationPresent(BeforeRetry.class) && !annotatedMethod.isAnnotationPresent(Retry.class)) {
                event.addDefinitionError((Throwable)CdiLogger.LOG.beforeRetryAnnotationWithoutRetry(method.method));
            }
            if (annotatedType.isAnnotationPresent(BeforeRetry.class) && !annotatedType.isAnnotationPresent(Retry.class)) {
                event.addDefinitionError((Throwable)CdiLogger.LOG.beforeRetryAnnotationWithoutRetry(annotatedType.getJavaClass()));
            }
            if (annotatedMethod.isAnnotationPresent(Asynchronous.class) && annotatedMethod.isAnnotationPresent(AsynchronousNonBlocking.class)) {
                event.addDefinitionError((Throwable)CdiLogger.LOG.bothAsyncAndAsyncNonBlockingPresent(method.method));
            }
            if (annotatedType.isAnnotationPresent(Asynchronous.class) && annotatedType.isAnnotationPresent(AsynchronousNonBlocking.class)) {
                event.addDefinitionError((Throwable)CdiLogger.LOG.bothAsyncAndAsyncNonBlockingPresent(annotatedType.getJavaClass()));
            }
            if (annotatedMethod.isAnnotationPresent(Blocking.class) && annotatedMethod.isAnnotationPresent(NonBlocking.class)) {
                event.addDefinitionError((Throwable)CdiLogger.LOG.bothBlockingNonBlockingPresent(method.method));
            }
            if (!annotatedType.isAnnotationPresent(Blocking.class) || !annotatedType.isAnnotationPresent(NonBlocking.class)) continue;
            event.addDefinitionError((Throwable)CdiLogger.LOG.bothBlockingNonBlockingPresent(annotatedType.getJavaClass()));
        }
    }

    void processBean(@Observes ProcessBean<?> pb) {
        boolean isGuard;
        Bean bean = pb.getBean();
        boolean bl = isGuard = bean.getTypes().contains(Guard.class) || bean.getTypes().contains(TypedGuard.class) || bean.getTypes().stream().anyMatch(it -> it instanceof ParameterizedType && ((ParameterizedType)it).getRawType().equals(TypedGuard.class));
        if (isGuard) {
            for (Annotation ann : bean.getQualifiers()) {
                if (!(ann instanceof Identifier)) continue;
                String id = ((Identifier)ann).value();
                this.existingGuards.computeIfAbsent(id, ignored -> new HashSet()).add(bean.toString());
                if (!"global".equals(id)) continue;
                pb.addDefinitionError((Throwable)CdiLogger.LOG.guardWithIdentifierGlobal(bean.toString()));
            }
        }
    }

    void validate(@Observes AfterDeploymentValidation event) {
        for (Map.Entry entry : this.existingCircuitBreakerNames.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            event.addDeploymentProblem((Throwable)CdiLogger.LOG.multipleCircuitBreakersWithTheSameName((String)entry.getKey(), (Set)entry.getValue()));
        }
        for (Map.Entry entry : this.existingGuards.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            event.addDeploymentProblem((Throwable)CdiLogger.LOG.multipleGuardsWithTheSameIdentifier((String)entry.getKey(), (Set)entry.getValue()));
        }
        for (String expectedGuard : this.expectedGuards) {
            if (this.existingGuards.containsKey(expectedGuard)) continue;
            event.addDeploymentProblem((Throwable)CdiLogger.LOG.expectedGuardDoesNotExist(expectedGuard));
        }
        this.existingGuards.clear();
        this.expectedGuards.clear();
    }

    private static String getCacheKey(Class<?> beanClass, Method method) {
        return beanClass.getName() + "::" + method.toGenericString();
    }

    FaultToleranceOperation getFaultToleranceOperation(Class<?> beanClass, Method method) {
        return (FaultToleranceOperation)((Object)this.faultToleranceOperations.get(FaultToleranceExtension.getCacheKey(beanClass, method)));
    }

    Set<String> getExistingCircuitBreakerNames() {
        return this.existingCircuitBreakerNames.keySet();
    }

    private static Optional<String> getImplementationVersion() {
        return AccessController.doPrivileged(new PrivilegedAction<Optional<String>>(){

            @Override
            public Optional<String> run() {
                Properties properties = new Properties();
                try {
                    InputStream resource = this.getClass().getClassLoader().getResourceAsStream("smallrye-fault-tolerance.properties");
                    if (resource != null) {
                        properties.load(resource);
                        return Optional.ofNullable(properties.getProperty("version"));
                    }
                }
                catch (IOException e) {
                    CdiLogger.LOG.debug("Unable to detect SmallRye Fault Tolerance version");
                }
                return Optional.empty();
            }
        });
    }

    public static class FTInterceptorBindingAnnotatedType<T extends Annotation>
    implements AnnotatedType<T> {
        private AnnotatedType<T> delegate;
        private Set<Annotation> annotations;

        public FTInterceptorBindingAnnotatedType(AnnotatedType<T> delegate) {
            this.delegate = delegate;
            this.annotations = new HashSet<Annotation>(delegate.getAnnotations());
            this.annotations.add(FaultToleranceBinding.Literal.INSTANCE);
        }

        public Class<T> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        public Set<AnnotatedConstructor<T>> getConstructors() {
            return this.delegate.getConstructors();
        }

        public Set<AnnotatedMethod<? super T>> getMethods() {
            return this.delegate.getMethods();
        }

        public Set<AnnotatedField<? super T>> getFields() {
            return this.delegate.getFields();
        }

        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        public <S extends Annotation> S getAnnotation(Class<S> annotationType) {
            if (FaultToleranceBinding.class.equals(annotationType)) {
                return (S)FaultToleranceBinding.Literal.INSTANCE;
            }
            return (S)this.delegate.getAnnotation(annotationType);
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return FaultToleranceBinding.class.equals(annotationType) || this.delegate.isAnnotationPresent(annotationType);
        }
    }

    public static class PriorityLiteral
    extends AnnotationLiteral<Priority>
    implements Priority {
        private static final long serialVersionUID = 1L;
        private final int value;

        public PriorityLiteral(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

