/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.context.ContextReference;

public class ThreadContextReference<C>
implements ContextReference<C> {
    private final Supplier<Thread> reference;
    private final Function<Thread, C> accessor;
    private final BiConsumer<Thread, C> applicator;

    public ThreadContextReference(Supplier<Thread> reference, Function<Thread, C> accessor, BiConsumer<Thread, C> applicator) {
        this.reference = reference;
        this.accessor = accessor;
        this.applicator = applicator;
    }

    @Override
    public void accept(final C context) {
        final Thread thread = this.reference.get();
        if (System.getSecurityManager() == null) {
            this.applicator.accept(thread, context);
        } else {
            final BiConsumer<Thread, C> applicator = this.applicator;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    applicator.accept(thread, context);
                    return null;
                }
            });
        }
    }

    @Override
    public C get() {
        final Thread thread = this.reference.get();
        if (System.getSecurityManager() == null) {
            return this.accessor.apply(thread);
        }
        final Function<Thread, C> accessor = this.accessor;
        return (C)AccessController.doPrivileged(new PrivilegedAction<C>(){

            @Override
            public C run() {
                return accessor.apply(thread);
            }
        });
    }
}

