/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.management.Capabilities;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.metrics.MetricCollector;
import org.wildfly.extension.metrics.MetricsSubsystemDefinition;

public class MetricsCollectorService
implements Service<MetricCollector> {
    private final Supplier<ModelControllerClientFactory> modelControllerClientFactory;
    private final Supplier<Executor> managementExecutor;
    private final Supplier<ProcessStateNotifier> processStateNotifier;
    private Consumer<MetricCollector> metricCollectorConsumer;
    private MetricCollector metricCollector;
    private LocalModelControllerClient modelControllerClient;

    static void install(OperationContext context) {
        CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addService(MetricsSubsystemDefinition.WILDFLY_COLLECTOR);
        Supplier modelControllerClientFactory = serviceBuilder.requires(ModelControllerClientFactory.SERVICE_DESCRIPTOR);
        Supplier managementExecutor = serviceBuilder.requires(Capabilities.MANAGEMENT_EXECUTOR);
        Supplier processStateNotifier = serviceBuilder.requires(ProcessStateNotifier.SERVICE_DESCRIPTOR);
        Consumer metricCollectorConsumer = serviceBuilder.provides(new ServiceName[]{MetricsSubsystemDefinition.WILDFLY_COLLECTOR});
        MetricsCollectorService service = new MetricsCollectorService(modelControllerClientFactory, managementExecutor, processStateNotifier, metricCollectorConsumer);
        serviceBuilder.setInstance((org.jboss.msc.Service)service).install();
    }

    MetricsCollectorService(Supplier<ModelControllerClientFactory> modelControllerClientFactory, Supplier<Executor> managementExecutor, Supplier<ProcessStateNotifier> processStateNotifier, Consumer<MetricCollector> metricCollectorConsumer) {
        this.modelControllerClientFactory = modelControllerClientFactory;
        this.managementExecutor = managementExecutor;
        this.processStateNotifier = processStateNotifier;
        this.metricCollectorConsumer = metricCollectorConsumer;
    }

    public void start(StartContext context) {
        this.modelControllerClient = this.modelControllerClientFactory.get().createClient(this.managementExecutor.get());
        this.metricCollector = new MetricCollector(this.modelControllerClient, this.processStateNotifier.get());
        this.metricCollectorConsumer.accept(this.metricCollector);
    }

    public void stop(StopContext context) {
        this.metricCollectorConsumer.accept(null);
        this.metricCollector = null;
        this.modelControllerClient.close();
    }

    public MetricCollector getValue() throws IllegalStateException, IllegalArgumentException {
        return this.metricCollector;
    }
}

