/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.util.ArrayList;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;
import org.jboss.vfs.VirtualFile;

public class JaxrsDependencyProcessor
implements DeploymentUnitProcessor {
    private static final String CLIENT_BUILDER = "META-INF/services/jakarta.ws.rs.client.ClientBuilder";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        WeldCapability api;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        boolean deploymentBundlesClientBuilder = this.isClientBuilderInDeployment(deploymentUnit);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDependency(moduleSpecification, moduleLoader, "jakarta.ws.rs.api", false, false);
        this.addDependency(moduleSpecification, moduleLoader, "jakarta.xml.bind.api", false, false);
        this.addDependency(moduleSpecification, moduleLoader, "jakarta.json.api", false, false);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-atom-provider", true, false);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-client", true, deploymentBundlesClientBuilder);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-client-api", true, deploymentBundlesClientBuilder);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-core", true, deploymentBundlesClientBuilder);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-core-spi", true, deploymentBundlesClientBuilder);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-client-microprofile", true, false);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-jaxb-provider", true, false);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-jackson2-provider", true, false);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-json-p-provider", true, false);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-json-binding-provider", true, false);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-jsapi", true, false);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-multipart-provider", true, false);
        this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-crypto", true, false);
        this.addDependency(moduleSpecification, moduleLoader, "com.fasterxml.jackson.datatype.jackson-datatype-jdk8", true, false);
        this.addDependency(moduleSpecification, moduleLoader, "com.fasterxml.jackson.datatype.jackson-datatype-jsr310", true, false);
        this.addDependency(moduleSpecification, moduleLoader, "com.fasterxml.jackson.core.jackson-annotations", true, false, false);
        this.addDependency(moduleSpecification, moduleLoader, "com.fasterxml.jackson.core.jackson-core", true, false, false);
        this.addDependency(moduleSpecification, moduleLoader, "com.fasterxml.jackson.core.jackson-databind", true, false, false);
        this.addDependency(moduleSpecification, moduleLoader, "com.fasterxml.jackson.jakarta.jackson-jakarta-json-provider", true, false, false);
        this.addDependency(moduleSpecification, moduleLoader, "org.reactivestreams", true, false, false);
        this.addDependency(moduleSpecification, moduleLoader, "io.reactivex.rxjava2.rxjava", true, false, false);
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        if (support.hasCapability("org.wildfly.weld") && (api = (WeldCapability)support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class).orElse(null)) != null && api.isPartOfWeldDeployment(deploymentUnit)) {
            this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.resteasy-cdi", true, false);
        }
        if (support.hasCapability("org.wildfly.microprofile.config")) {
            this.addDependency(moduleSpecification, moduleLoader, "org.eclipse.microprofile.restclient", true, false);
            this.addDependency(moduleSpecification, moduleLoader, "org.jboss.resteasy.microprofile.config", true, false);
        }
        if (support.hasCapability("org.wildfly.bean-validation")) {
            ModuleDependency dep = ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"org.jboss.resteasy.resteasy-validator-provider").setOptional(true).setExport(true).setImportServices(true).build();
            moduleSpecification.addSystemDependency(dep);
        }
    }

    private boolean isClientBuilderInDeployment(DeploymentUnit deploymentUnit) {
        ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        ArrayList<ResourceRoot> roots = new ArrayList<ResourceRoot>(deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS));
        roots.add(root);
        for (ResourceRoot r : roots) {
            VirtualFile file = r.getRoot().getChild(CLIENT_BUILDER);
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, String moduleIdentifier, boolean optional, boolean deploymentBundlesClientBuilder) {
        this.addDependency(moduleSpecification, moduleLoader, moduleIdentifier, optional, deploymentBundlesClientBuilder, true);
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, String moduleIdentifier, boolean optional, boolean deploymentBundlesClientBuilder, boolean importServices) {
        ModuleDependency dependency = ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)moduleIdentifier).setOptional(optional).setImportServices(importServices).build();
        if (deploymentBundlesClientBuilder) {
            dependency.addImportFilter(PathFilters.is((String)CLIENT_BUILDER), false);
        }
        moduleSpecification.addSystemDependency(dependency);
    }
}

