/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.ManagerOperationsFactory;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.BasicConfiguration;

public class RemoteCacheManagerAdminImpl
implements RemoteCacheManagerAdmin {
    public static final String CACHE_NAME = "name";
    public static final String ALIAS_NAME = "alias";
    public static final String CACHE_TEMPLATE = "template";
    public static final String CACHE_CONFIGURATION = "configuration";
    public static final String ATTRIBUTE = "attribute";
    public static final String VALUE = "value";
    public static final String FLAGS = "flags";
    private final RemoteCacheManager cacheManager;
    private final ManagerOperationsFactory operationsFactory;
    private final OperationDispatcher operationDispatcher;
    private final EnumSet<CacheContainerAdmin.AdminFlag> flags;
    private final Consumer<String> remover;

    public RemoteCacheManagerAdminImpl(RemoteCacheManager cacheManager, ManagerOperationsFactory operationsFactory, OperationDispatcher operationDispatcher, EnumSet<CacheContainerAdmin.AdminFlag> flags, Consumer<String> remover) {
        this.cacheManager = cacheManager;
        this.operationsFactory = operationsFactory;
        this.operationDispatcher = operationDispatcher;
        this.flags = flags;
        this.remover = remover;
    }

    @Override
    public <K, V> RemoteCache<K, V> createCache(String name, String template) throws HotRodClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
        params.put(CACHE_NAME, RemoteCacheManagerAdminImpl.string(name));
        if (template != null) {
            params.put(CACHE_TEMPLATE, RemoteCacheManagerAdminImpl.string(template));
        }
        if (this.flags != null && !this.flags.isEmpty()) {
            params.put(FLAGS, RemoteCacheManagerAdminImpl.flags(this.flags));
        }
        Util.await(this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@cache@create", params)));
        return this.cacheManager.getCache(name);
    }

    @Override
    public <K, V> RemoteCache<K, V> createCache(String name, DefaultTemplate template) throws HotRodClientException {
        return this.createCache(name, (BasicConfiguration)template.getConfiguration());
    }

    @Override
    public <K, V> RemoteCache<K, V> createCache(String name, BasicConfiguration configuration) throws HotRodClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
        params.put(CACHE_NAME, RemoteCacheManagerAdminImpl.string(name));
        if (configuration != null) {
            params.put(CACHE_CONFIGURATION, RemoteCacheManagerAdminImpl.string(configuration.toStringConfiguration(name)));
        }
        if (this.flags != null && !this.flags.isEmpty()) {
            params.put(FLAGS, RemoteCacheManagerAdminImpl.flags(this.flags));
        }
        Util.await(this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@cache@create", params)));
        return this.cacheManager.getCache(name);
    }

    @Override
    public <K, V> RemoteCache<K, V> getOrCreateCache(String name, String template) throws HotRodClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
        params.put(CACHE_NAME, RemoteCacheManagerAdminImpl.string(name));
        if (template != null) {
            params.put(CACHE_TEMPLATE, RemoteCacheManagerAdminImpl.string(template));
        }
        if (this.flags != null && !this.flags.isEmpty()) {
            params.put(FLAGS, RemoteCacheManagerAdminImpl.flags(this.flags));
        }
        Util.await(this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@cache@getorcreate", params)));
        return this.cacheManager.getCache(name);
    }

    @Override
    public <K, V> RemoteCache<K, V> getOrCreateCache(String name, DefaultTemplate template) throws HotRodClientException {
        return this.getOrCreateCache(name, (BasicConfiguration)template.getConfiguration());
    }

    @Override
    public <K, V> RemoteCache<K, V> getOrCreateCache(String name, BasicConfiguration configuration) throws HotRodClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
        params.put(CACHE_NAME, RemoteCacheManagerAdminImpl.string(name));
        if (configuration != null) {
            params.put(CACHE_CONFIGURATION, RemoteCacheManagerAdminImpl.string(configuration.toStringConfiguration(name)));
        }
        if (this.flags != null && !this.flags.isEmpty()) {
            params.put(FLAGS, RemoteCacheManagerAdminImpl.flags(this.flags));
        }
        Util.await(this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@cache@getorcreate", params)));
        return this.cacheManager.getCache(name);
    }

    @Override
    public void removeCache(String name) {
        this.remover.accept(name);
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
        params.put(CACHE_NAME, RemoteCacheManagerAdminImpl.string(name));
        if (this.flags != null && !this.flags.isEmpty()) {
            params.put(FLAGS, RemoteCacheManagerAdminImpl.flags(this.flags));
        }
        Util.await(this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@cache@remove", params)));
    }

    public RemoteCacheManagerAdmin withFlags(CacheContainerAdmin.AdminFlag ... flags) {
        EnumSet<CacheContainerAdmin.AdminFlag> newFlags = EnumSet.copyOf(this.flags);
        Collections.addAll(newFlags, flags);
        return new RemoteCacheManagerAdminImpl(this.cacheManager, this.operationsFactory, this.operationDispatcher, newFlags, this.remover);
    }

    public RemoteCacheManagerAdmin withFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        EnumSet<CacheContainerAdmin.AdminFlag> newFlags = EnumSet.copyOf(this.flags);
        newFlags.addAll(flags);
        return new RemoteCacheManagerAdminImpl(this.cacheManager, this.operationsFactory, this.operationDispatcher, newFlags, this.remover);
    }

    @Override
    public void reindexCache(String name) throws HotRodClientException {
        Util.await(this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@cache@reindex", Collections.singletonMap(CACHE_NAME, RemoteCacheManagerAdminImpl.string(name)))));
    }

    @Override
    public void updateIndexSchema(String name) throws HotRodClientException {
        Util.await(this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@cache@updateindexschema", Collections.singletonMap(CACHE_NAME, RemoteCacheManagerAdminImpl.string(name)))));
    }

    @Override
    public void updateConfigurationAttribute(String name, String attribute, String value) throws HotRodClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(4);
        params.put(CACHE_NAME, RemoteCacheManagerAdminImpl.string(name));
        params.put(ATTRIBUTE, RemoteCacheManagerAdminImpl.string(attribute));
        params.put(VALUE, RemoteCacheManagerAdminImpl.string(value));
        if (this.flags != null && !this.flags.isEmpty()) {
            params.put(FLAGS, RemoteCacheManagerAdminImpl.flags(this.flags));
        }
        Util.await(this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@cache@updateConfigurationAttribute", params)));
    }

    public void createTemplate(String name, BasicConfiguration configuration) {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
        params.put(CACHE_NAME, RemoteCacheManagerAdminImpl.string(name));
        if (configuration != null) {
            params.put(CACHE_CONFIGURATION, RemoteCacheManagerAdminImpl.string(configuration.toStringConfiguration(name)));
        }
        if (this.flags != null && !this.flags.isEmpty()) {
            params.put(FLAGS, RemoteCacheManagerAdminImpl.flags(this.flags));
        }
        Util.await(this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@template@create", params)));
    }

    public void removeTemplate(String name) {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
        params.put(CACHE_NAME, RemoteCacheManagerAdminImpl.string(name));
        if (this.flags != null && !this.flags.isEmpty()) {
            params.put(FLAGS, RemoteCacheManagerAdminImpl.flags(this.flags));
        }
        Util.await(this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@template@remove", params)));
    }

    @Override
    public void assignAlias(String aliasName, String cacheName) throws HotRodClientException {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(4);
        params.put(CACHE_NAME, RemoteCacheManagerAdminImpl.string(cacheName));
        params.put(ALIAS_NAME, RemoteCacheManagerAdminImpl.string(aliasName));
        if (this.flags != null && !this.flags.isEmpty()) {
            params.put(FLAGS, RemoteCacheManagerAdminImpl.flags(this.flags));
        }
        Util.await(this.operationDispatcher.execute(this.operationsFactory.executeOperation("@@cache@assignAlias", params)));
    }

    private static byte[] flags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        String sFlags = flags.stream().map(Enum::toString).collect(Collectors.joining(","));
        return RemoteCacheManagerAdminImpl.string(sFlags);
    }

    private static byte[] string(String s) {
        return s.getBytes(HotRodConstants.HOTROD_STRING_CHARSET);
    }
}

