/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.operations.ClientListenerOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class AddBloomNearCacheClientListenerOperation
extends ClientListenerOperation {
    private final int bloomFilterBits;

    protected AddBloomNearCacheClientListenerOperation(InternalRemoteCache<?, ?> remoteCache, Object listener, int bloomFilterBits) {
        super(remoteCache, listener);
        this.bloomFilterBits = bloomFilterBits;
    }

    private AddBloomNearCacheClientListenerOperation(InternalRemoteCache<?, ?> remoteCache, Object listener, byte[] listenerId, int bloomFilterBits) {
        super(remoteCache, listener, listenerId);
        this.bloomFilterBits = bloomFilterBits;
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        ByteBufUtil.writeArray(buf, this.listenerId);
        codec.writeBloomFilter(buf, this.bloomFilterBits);
    }

    @Override
    public Channel createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        return decoder.getChannel();
    }

    @Override
    public short requestOpCode() {
        return 65;
    }

    @Override
    public short responseOpCode() {
        return 66;
    }

    @Override
    public ClientListenerOperation copy() {
        return new AddBloomNearCacheClientListenerOperation(this.internalRemoteCache, this.listener, this.listenerId, this.bloomFilterBits);
    }
}

