/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.impl.operations.ByteBufSwappableInputStream;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.marshall.Marshaller;

public class ByteBufCacheUnmarshaller
implements CacheUnmarshaller {
    private final ClassAllowList allowList;
    private final ByteBufSwappableInputStream inputStream;
    private DataFormat format;

    public ByteBufCacheUnmarshaller(ClassAllowList allowList) {
        this.allowList = allowList;
        this.inputStream = new ByteBufSwappableInputStream();
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.format = dataFormat;
    }

    @Override
    public <E> E readKey(ByteBuf buf) {
        int length = ByteBufUtil.readVInt(buf);
        return this.readKey(buf, length);
    }

    @Override
    public <E> E readKey(ByteBuf buf, int length) {
        if (buf.readableBytes() < length) {
            buf.skipBytes(length);
        }
        if (length == 0) {
            return null;
        }
        this.inputStream.setBuffer(buf, length);
        return (E)this.format.keyToObject(this.inputStream, this.allowList);
    }

    @Override
    public <E> E readValue(ByteBuf buf) {
        int length = ByteBufUtil.readVInt(buf);
        return this.readValue(buf, length);
    }

    @Override
    public <E> E readValue(ByteBuf buf, int length) {
        if (buf.readableBytes() < length) {
            buf.skipBytes(length);
        }
        if (length == 0) {
            return null;
        }
        this.inputStream.setBuffer(buf, length);
        return (E)this.format.valueToObj(this.inputStream, this.allowList);
    }

    @Override
    public <E> E readOther(ByteBuf buf) {
        int length = ByteBufUtil.readVInt(buf);
        return this.readOther(buf, length);
    }

    @Override
    public <E> E readOther(ByteBuf buf, int length) {
        if (buf.readableBytes() < length) {
            buf.skipBytes(length);
        }
        if (length == 0) {
            return null;
        }
        this.inputStream.setBuffer(buf, length);
        Marshaller marshaller = this.format.getDefaultMarshaller();
        return (E)MarshallerUtil.bytes2obj(marshaller, this.inputStream, this.format.isObjectStorage(), this.allowList);
    }
}

