/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class GetWithMetadataOperation<V>
extends AbstractKeyOperation<GetWithMetadataResult<V>> {
    private static final Log log = LogFactory.getLog(GetWithMetadataOperation.class);
    private final Channel preferredChannel;

    public GetWithMetadataOperation(InternalRemoteCache<?, ?> remoteCache, byte[] keyBytes, Channel preferredChannel) {
        super(remoteCache, keyBytes);
        this.preferredChannel = preferredChannel;
    }

    @Override
    public GetWithMetadataResult<V> createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        boolean retried = this.preferredChannel != null && !this.preferredChannel.equals((Object)decoder.getChannel());
        MetadataValue<V> metadataValue = GetWithMetadataOperation.readMetadataValue(buf, status, unmarshaller);
        return new GetWithMetadataResult<V>(metadataValue, retried);
    }

    @Override
    public void handleStatsCompletion(ClientStatistics statistics, long startTime, short status, GetWithMetadataResult<V> responseValue) {
        statistics.dataRead(responseValue.value != null, startTime, 1);
    }

    public static <V> MetadataValue<V> readMetadataValue(ByteBuf buf, short status, CacheUnmarshaller unmarshaller) {
        if (HotRodConstants.isNotExist(status) || !HotRodConstants.isSuccess(status) && !HotRodConstants.hasPrevious(status)) {
            return null;
        }
        short flags = buf.readUnsignedByte();
        long creation = -1L;
        int lifespan = -1;
        long lastUsed = -1L;
        int maxIdle = -1;
        if ((flags & 1) != 1) {
            creation = buf.readLong();
            lifespan = ByteBufUtil.readVInt(buf);
        }
        if ((flags & 2) != 2) {
            lastUsed = buf.readLong();
            maxIdle = ByteBufUtil.readVInt(buf);
        }
        long version = buf.readLong();
        if (log.isTraceEnabled()) {
            log.tracef("Received version: %d", version);
        }
        Object value = unmarshaller.readValue(buf);
        return new MetadataValueImpl(creation, lifespan, lastUsed, maxIdle, version, value);
    }

    @Override
    public short requestOpCode() {
        return 27;
    }

    @Override
    public short responseOpCode() {
        return 28;
    }

    public record GetWithMetadataResult<V>(MetadataValue<V> value, boolean retried) {
    }
}

