/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import io.vertx.amqp.AmqpMessage;
import io.vertx.amqp.impl.AmqpMessageImpl;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import java.sql.Date;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.eclipse.microprofile.reactive.messaging.Message;

public class AmqpMessageConverter {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String BINARY_CONTENT_TYPE = "application/octet-stream";
    private static final List<Class<?>> PRIMITIVES = Arrays.asList(Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Double.class, Float.class, Long.class);

    private AmqpMessageConverter() {
    }

    static io.vertx.mutiny.amqp.AmqpMessage convertToAmqpMessage(Message<?> message, boolean durable, long ttl) {
        Object payload = message.getPayload();
        OutgoingAmqpMetadata metadata = message.getMetadata(OutgoingAmqpMetadata.class).orElse(new OutgoingAmqpMetadata());
        org.apache.qpid.proton.message.Message output = Message.Factory.create();
        if (metadata.isDurable()) {
            output.setDurable(true);
        } else {
            output.setDurable(durable);
        }
        output.setPriority(metadata.getPriority());
        if (metadata.getTtl() > 0L) {
            output.setTtl(metadata.getTtl());
        } else if (ttl > 0L) {
            output.setTtl(ttl);
        }
        DeliveryAnnotations deliveryAnnotations = metadata.getDeliveryAnnotations();
        MessageAnnotations messageAnnotations = metadata.getMessageAnnotations();
        if (!deliveryAnnotations.getValue().isEmpty()) {
            output.setDeliveryAnnotations(deliveryAnnotations);
        }
        if (!messageAnnotations.getValue().isEmpty()) {
            output.setMessageAnnotations(messageAnnotations);
        }
        output.setMessageId((Object)metadata.getMessageId());
        output.setUserId(metadata.getUserId() != null ? metadata.getUserId().getBytes() : null);
        output.setAddress(metadata.getAddress());
        output.setSubject(metadata.getSubject());
        output.setReplyTo(metadata.getReplyTo());
        output.setCorrelationId((Object)metadata.getCorrelationId());
        output.setContentType(metadata.getContentType());
        output.setContentEncoding(metadata.getContentEncoding());
        output.setExpiryTime(metadata.getExpiryTime());
        output.setCreationTime(metadata.getCreationTime());
        output.setGroupId(metadata.getGroupId());
        output.setGroupSequence(metadata.getGroupSequence());
        output.setReplyToGroupId(metadata.getReplyToGroupId());
        if (!metadata.getProperties().isEmpty()) {
            output.setApplicationProperties(new ApplicationProperties(metadata.getProperties().getMap()));
        }
        if (payload == null) {
            output.setBody((Section)new AmqpValue(null));
        } else if (payload instanceof String || AmqpMessageConverter.isPrimitive(payload.getClass()) || payload instanceof UUID) {
            output.setBody((Section)new AmqpValue(payload));
        } else if (payload instanceof Buffer) {
            output.setBody((Section)new Data(new Binary(((Buffer)payload).getBytes())));
            if (output.getContentType() == null) {
                output.setContentType(BINARY_CONTENT_TYPE);
            }
        } else if (payload instanceof io.vertx.core.buffer.Buffer) {
            output.setBody((Section)new Data(new Binary(((io.vertx.core.buffer.Buffer)payload).getBytes())));
            if (output.getContentType() == null) {
                output.setContentType(BINARY_CONTENT_TYPE);
            }
        } else if (payload instanceof Instant) {
            output.setBody((Section)new AmqpValue((Object)Date.from((Instant)payload)));
        } else if (payload instanceof JsonArray) {
            bytes = ((JsonArray)payload).toBuffer().getBytes();
            output.setBody((Section)new Data(new Binary(bytes)));
            if (output.getContentType() == null) {
                output.setContentType(JSON_CONTENT_TYPE);
            }
        } else if (payload instanceof JsonObject) {
            bytes = ((JsonObject)payload).toBuffer().getBytes();
            output.setBody((Section)new Data(new Binary(bytes)));
            if (output.getContentType() == null) {
                output.setContentType(JSON_CONTENT_TYPE);
            }
        } else if (payload instanceof byte[]) {
            output.setBody((Section)new Data(new Binary((byte[])payload)));
            if (output.getContentType() == null) {
                output.setContentType(BINARY_CONTENT_TYPE);
            }
        } else if (payload instanceof Map || payload instanceof List) {
            output.setBody((Section)new AmqpValue(payload));
        } else {
            bytes = Json.encodeToBuffer((Object)payload).getBytes();
            output.setBody((Section)new Data(new Binary(bytes)));
            if (output.getContentType() == null) {
                output.setContentType(JSON_CONTENT_TYPE);
            }
        }
        Footer footer = metadata.getFooter();
        if (!footer.getValue().isEmpty()) {
            output.setFooter(footer);
        }
        return new io.vertx.mutiny.amqp.AmqpMessage((AmqpMessage)new AmqpMessageImpl(output));
    }

    private static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || PRIMITIVES.contains(clazz);
    }
}

