/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.classloader;

import io.smallrye.common.classloader.DefineClassPermission;
import java.lang.invoke.MethodHandles;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ClassDefiner {
    private ClassDefiner() {
    }

    public static Class<?> defineClass(final MethodHandles.Lookup lookup, final Class<?> parent, String className, final byte[] classBytes) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(DefineClassPermission.getInstance());
        }
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    MethodHandles.Lookup privateLookupIn = MethodHandles.privateLookupIn(parent, lookup);
                    return privateLookupIn.defineClass(classBytes);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
            }
        });
    }
}

