/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.MultistepUtil;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.extension.picketlink.federation.FederationExtension;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class MigrateOperation
implements OperationStepHandler {
    private static final String KEYCLOAK_SAML_EXTENSION = "org.keycloak.keycloak-saml-adapter-subsystem";
    private static final String KEYCLOAK_SAML = "keycloak-saml";
    private static final String PICKETLINK_EXTENSION = "org.wildfly.extension.picketlink";
    private static final PathAddress PICKETLINK_EXTENSION_ADDRESS = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"extension", (String)"org.wildfly.extension.picketlink")});
    private static final OperationStepHandler DESCRIBE_MIGRATION_INSTANCE = new MigrateOperation(true);
    private static final OperationStepHandler MIGRATE_INSTANCE = new MigrateOperation(false);
    private static final String MIGRATE = "migrate";
    private static final String MIGRATION_WARNINGS = "migration-warnings";
    private static final String MIGRATION_ERROR = "migration-error";
    private static final String MIGRATION_OPERATIONS = "migration-operations";
    private static final String DESCRIBE_MIGRATION = "describe-migration";
    static final StringListAttributeDefinition MIGRATION_WARNINGS_ATTR = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("migration-warnings").setRequired(false)).build();
    static final SimpleMapAttributeDefinition MIGRATION_ERROR_ATTR = ((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("migration-error", ModelType.OBJECT, true).setValueType(ModelType.OBJECT).setRequired(false)).build();
    private final boolean describe;

    private MigrateOperation(boolean describe) {
        this.describe = describe;
    }

    static void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(MIGRATE, resourceDescriptionResolver).setReplyParameters(new AttributeDefinition[]{MIGRATION_WARNINGS_ATTR, MIGRATION_ERROR_ATTR}).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).build(), MIGRATE_INSTANCE);
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(DESCRIBE_MIGRATION, resourceDescriptionResolver).setReplyParameters(new AttributeDefinition[]{MIGRATION_WARNINGS_ATTR}).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG}).setReadOnly().build(), DESCRIBE_MIGRATION_INSTANCE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!this.describe && context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw PicketLinkLogger.ROOT_LOGGER.migrateOperationAllowedOnlyInAdminOnly();
        }
        final ArrayList warnings = new ArrayList();
        final ModelNode legacyModelAddOps = new ModelNode();
        final LinkedHashMap<PathAddress, ModelNode> migrationOperations = new LinkedHashMap<PathAddress, ModelNode>();
        this.describeLegacyPicketLinkFederationResources(context, legacyModelAddOps);
        this.addKeycloakSamlExtension(context, migrationOperations, this.describe);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                MigrateOperation.this.transformResources(context, legacyModelAddOps, migrationOperations, warnings);
                MigrateOperation.this.removePicketLinkFederation(migrationOperations, context.getProcessType() == ProcessType.STANDALONE_SERVER);
                PathAddress parentAddress = context.getCurrentAddress().getParent();
                MigrateOperation.this.fixAddressesForDomainMode(parentAddress, migrationOperations);
                if (MigrateOperation.this.describe) {
                    Collection values = migrationOperations.values();
                    ModelNode result = new ModelNode();
                    MigrateOperation.this.fillWarnings(result, warnings);
                    result.get(MigrateOperation.MIGRATION_OPERATIONS).set(values);
                    context.getResult().set(result);
                } else {
                    final Map<PathAddress, ModelNode> migrateOpResponses = MigrateOperation.this.migrateSubsystems(context, migrationOperations);
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            ModelNode result = new ModelNode();
                            MigrateOperation.this.fillWarnings(result, warnings);
                            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                for (Map.Entry entry : migrateOpResponses.entrySet()) {
                                    if (!((ModelNode)entry.getValue()).hasDefined("failure-description")) continue;
                                    ModelNode desc = new ModelNode();
                                    desc.get("operation").set((ModelNode)migrationOperations.get(entry.getKey()));
                                    desc.get("result").set((ModelNode)entry.getValue());
                                    result.get(MigrateOperation.MIGRATION_ERROR).set(desc);
                                    break;
                                }
                                context.getFailureDescription().set(PicketLinkLogger.ROOT_LOGGER.migrationFailed());
                            }
                            context.getResult().set(result);
                        }
                    });
                }
            }
        }, OperationContext.Stage.MODEL);
    }

    private void describeLegacyPicketLinkFederationResources(OperationContext context, ModelNode legacyModelDescription) {
        ModelNode describeLegacySubsystem = Util.createOperation((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (PathAddress)context.getCurrentAddress());
        context.addStep(legacyModelDescription, describeLegacySubsystem, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, OperationContext.Stage.MODEL, true);
    }

    private void addKeycloakSamlExtension(OperationContext context, Map<PathAddress, ModelNode> migrationOperations, boolean describe) {
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        if (root.getChildrenNames("extension").contains(KEYCLOAK_SAML_EXTENSION)) {
            return;
        }
        PathAddress extensionAddress = PathAddress.pathAddress((String)"extension", (String)KEYCLOAK_SAML_EXTENSION);
        OperationEntry addEntry = context.getRootResourceRegistration().getOperationEntry(extensionAddress, "add");
        ModelNode addOperation = Util.createAddOperation((PathAddress)extensionAddress);
        addOperation.get("module").set(KEYCLOAK_SAML_EXTENSION);
        if (describe) {
            migrationOperations.put(extensionAddress, addOperation);
        } else {
            context.addStep(context.getResult().get(extensionAddress.toString()), addOperation, addEntry.getOperationHandler(), OperationContext.Stage.MODEL);
        }
    }

    private void transformResources(OperationContext context, ModelNode legacyModelDescription, Map<PathAddress, ModelNode> newAddOperations, List<String> warnings) throws OperationFailedException {
        for (ModelNode legacyAddOp : legacyModelDescription.get("result").asList()) {
            ModelNode newAddOp = legacyAddOp.clone();
            ModelNode legacyAddress = legacyAddOp.get("address");
            ModelNode newAddress = this.transformAddress(legacyAddress.clone(), context);
            if (!newAddress.isDefined()) continue;
            newAddOp.get("address").set(newAddress);
            PathAddress address = PathAddress.pathAddress((ModelNode)newAddress);
            if (address.size() > 1) {
                throw PicketLinkLogger.ROOT_LOGGER.cannotMigrateNonEmptyConfiguration();
            }
            newAddOperations.put(address, newAddOp);
        }
    }

    private ModelNode transformAddress(ModelNode legacyAddress, OperationContext context) {
        Resource root;
        ModelNode newAddress = new ModelNode();
        if (legacyAddress.asPropertyList().size() == 1 && (root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false)).getChildrenNames("subsystem").contains(KEYCLOAK_SAML)) {
            return new ModelNode();
        }
        for (Property segment : legacyAddress.asPropertyList()) {
            newAddress.add(switch (segment.getName()) {
                case "subsystem" -> new Property("subsystem", new ModelNode(KEYCLOAK_SAML));
                default -> segment;
            });
        }
        return newAddress;
    }

    private void removePicketLinkFederation(Map<PathAddress, ModelNode> migrationOperations, boolean standalone) {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{FederationExtension.SUBSYSTEM_PATH});
        ModelNode removeOperation = Util.createRemoveOperation((PathAddress)subsystemAddress);
        migrationOperations.put(subsystemAddress, removeOperation);
        if (standalone) {
            removeOperation = Util.createRemoveOperation((PathAddress)PICKETLINK_EXTENSION_ADDRESS);
            migrationOperations.put(PICKETLINK_EXTENSION_ADDRESS, removeOperation);
        }
    }

    private Map<PathAddress, ModelNode> migrateSubsystems(OperationContext context, Map<PathAddress, ModelNode> migrationOperations) throws OperationFailedException {
        LinkedHashMap<PathAddress, ModelNode> result = new LinkedHashMap<PathAddress, ModelNode>();
        MultistepUtil.recordOperationSteps((OperationContext)context, migrationOperations, result);
        return result;
    }

    private void fixAddressesForDomainMode(PathAddress parentAddress, Map<PathAddress, ModelNode> migrationOperations) {
        if (parentAddress.size() == 0) {
            return;
        }
        LinkedHashMap<PathAddress, ModelNode> fixedMigrationOperations = new LinkedHashMap<PathAddress, ModelNode>(migrationOperations);
        migrationOperations.clear();
        for (Map.Entry entry : fixedMigrationOperations.entrySet()) {
            PathAddress fixedAddress = parentAddress.append((PathAddress)entry.getKey());
            ((ModelNode)entry.getValue()).get("address").set(fixedAddress.toModelNode());
            migrationOperations.put(fixedAddress, (ModelNode)entry.getValue());
        }
    }

    private void fillWarnings(ModelNode result, List<String> warnings) {
        ModelNode rw = new ModelNode().setEmptyList();
        for (String warning : warnings) {
            rw.add(warning);
        }
        result.get(MIGRATION_WARNINGS).set(rw);
    }
}

