/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.otlp;

import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.micrometer.MicrometerSubsystemRegistrar;
import org.wildfly.extension.micrometer.WildFlyMicrometerConfig;
import org.wildfly.extension.micrometer.otlp.WildFlyOtlpRegistry;
import org.wildfly.extension.micrometer.registry.WildFlyCompositeRegistry;
import org.wildfly.service.Installer;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceInstaller;

public class OtlpRegistryDefinitionRegistrar
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator {
    static final String NAME = "otlp";
    public static final PathElement PATH = PathElement.pathElement((String)"registry", (String)"otlp");
    public static final RuntimeCapability<Void> MICROMETER_OTLP_CONFIG_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.micrometer.wildfly-otlp-config", WildFlyMicrometerConfig.class).build();
    public static final SimpleAttributeDefinition ENDPOINT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"endpoint", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition STEP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"step", (ModelType)ModelType.LONG, (boolean)true).setDefaultValue(new ModelNode(60L))).setMeasurementUnit(MeasurementUnit.SECONDS)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(ENDPOINT, STEP);
    private final WildFlyCompositeRegistry compositeRegistry;

    public OtlpRegistryDefinitionRegistrar(WildFlyCompositeRegistry compositeRegistry) {
        this.compositeRegistry = compositeRegistry;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ResourceRegistration registration = ResourceRegistration.of((PathElement)PATH);
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)MicrometerSubsystemRegistrar.RESOLVER.createChildResolver(PATH)).addAttributes(ATTRIBUTES)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).build();
        ManagementResourceRegistration mrr = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)registration, (ResourceDescriptionResolver)descriptor.getResourceDescriptionResolver()).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(mrr);
        return mrr;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        WildFlyOtlpRegistry.WildFlyMicrometerOtlpConfig otlpConfig = new WildFlyOtlpRegistry.WildFlyMicrometerOtlpConfig.Builder().endpoint(ENDPOINT.resolveModelAttribute(context, model).asStringOrNull()).step(STEP.resolveModelAttribute(context, model).asLong()).build();
        return (ResourceServiceInstaller)((ServiceInstaller.Builder)ServiceInstaller.builder(() -> {
            if (otlpConfig.url() != null) {
                this.compositeRegistry.addRegistry(new WildFlyOtlpRegistry(otlpConfig));
            }
        }, () -> {}).startWhen(Installer.StartWhen.INSTALLED)).build();
    }
}

