/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.InvocationContext;
import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class AroundTimeoutAnnotationParsingProcessor
implements DeploymentUnitProcessor {
    private static final DotName AROUND_TIMEOUT_ANNOTATION_NAME = DotName.createSimple((String)AroundTimeout.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        List aroundInvokes = index.getAnnotations(AROUND_TIMEOUT_ANNOTATION_NAME);
        for (AnnotationInstance annotation : aroundInvokes) {
            this.processAroundInvoke(annotation.target(), eeModuleDescription);
        }
    }

    private void processAroundInvoke(AnnotationTarget target, EEModuleDescription eeModuleDescription) {
        if (!(target instanceof MethodInfo)) {
            throw EjbLogger.ROOT_LOGGER.annotationApplicableOnlyForMethods(AROUND_TIMEOUT_ANNOTATION_NAME.toString());
        }
        MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
        ClassInfo classInfo = methodInfo.declaringClass();
        EEModuleClassDescription classDescription = eeModuleDescription.addOrGetLocalClassDescription(classInfo.name().toString());
        this.validateArgumentType(classInfo, methodInfo);
        InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder((InterceptorClassDescription)classDescription.getInterceptorClassDescription());
        builder.setAroundTimeout(MethodIdentifier.getIdentifier(Object.class, (String)methodInfo.name(), (Class[])new Class[]{InvocationContext.class}));
        classDescription.setInterceptorClassDescription(builder.build());
    }

    private void validateArgumentType(ClassInfo classInfo, MethodInfo methodInfo) {
        Type[] args = methodInfo.args();
        switch (args.length) {
            case 0: {
                throw EjbLogger.ROOT_LOGGER.aroundTimeoutMethodExpectedWithInvocationContextParam(methodInfo.name(), classInfo.toString());
            }
            case 1: {
                if (InvocationContext.class.getName().equals(args[0].name().toString())) break;
                throw EjbLogger.ROOT_LOGGER.aroundTimeoutMethodExpectedWithInvocationContextParam(methodInfo.name(), classInfo.toString());
            }
            default: {
                throw EjbLogger.ROOT_LOGGER.aroundTimeoutMethodExpectedWithInvocationContextParam(methodInfo.name(), classInfo.toString());
            }
        }
        if (!methodInfo.returnType().name().toString().equals(Object.class.getName())) {
            throw EjbLogger.ROOT_LOGGER.aroundTimeoutMethodMustReturnObjectType(methodInfo.name(), classInfo.toString());
        }
    }
}

