/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.inflow;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ApplicationServerInternalException;
import jakarta.resource.spi.LocalTransactionException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.XAResource;
import org.jboss.as.ejb3.inflow.AbstractInvocationHandler;
import org.jboss.as.ejb3.inflow.MessageEndpointService;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class MessageEndpointInvocationHandler
extends AbstractInvocationHandler
implements MessageEndpoint {
    private final MessageEndpointService service;
    private final Object delegate;
    private final XAResource xaRes;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private Transaction currentTx;
    private ClassLoader previousClassLoader;
    private Transaction previousTx;

    MessageEndpointInvocationHandler(MessageEndpointService service, Object delegate, XAResource xaResource) {
        this.service = service;
        this.delegate = delegate;
        this.xaRes = xaResource;
    }

    public void afterDelivery() throws ResourceException {
        TransactionManager tm = this.getTransactionManager();
        try {
            if (this.currentTx != null) {
                if (this.currentTx.getStatus() == 1) {
                    tm.rollback();
                } else {
                    tm.commit();
                }
                this.currentTx = null;
            }
            if (this.previousTx != null) {
                tm.resume(this.previousTx);
                this.previousTx = null;
            }
        }
        catch (InvalidTransactionException e) {
            throw new LocalTransactionException((Throwable)e);
        }
        catch (HeuristicMixedException e) {
            throw new LocalTransactionException((Throwable)e);
        }
        catch (SystemException e) {
            throw new LocalTransactionException((Throwable)e);
        }
        catch (HeuristicRollbackException e) {
            throw new LocalTransactionException((Throwable)e);
        }
        catch (RollbackException e) {
            throw new LocalTransactionException((Throwable)e);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.previousClassLoader);
            this.previousClassLoader = null;
        }
    }

    public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
        this.previousClassLoader = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.getApplicationClassLoader());
        try {
            TransactionManager tm = this.getTransactionManager();
            this.previousTx = tm.suspend();
            boolean isTransacted = this.service.isDeliveryTransacted(method);
            if (isTransacted) {
                tm.begin();
                this.currentTx = tm.getTransaction();
                if (this.xaRes != null) {
                    this.currentTx.enlistResource(this.xaRes);
                }
            }
        }
        catch (Throwable t) {
            throw new ApplicationServerInternalException(t);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.previousClassLoader);
        }
    }

    @Override
    protected boolean doEquals(Object obj) {
        if (!(obj instanceof MessageEndpointInvocationHandler)) {
            return false;
        }
        return this.delegate.equals(((MessageEndpointInvocationHandler)obj).delegate);
    }

    @Override
    protected Object doInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.released.get()) {
            throw EjbLogger.ROOT_LOGGER.messageEndpointAlreadyReleased(this);
        }
        if (method.getDeclaringClass().equals(MessageEndpoint.class)) {
            return this.handle(method, args);
        }
        try {
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    protected final ClassLoader getApplicationClassLoader() {
        return this.service.getClassLoader();
    }

    protected final TransactionManager getTransactionManager() {
        return this.service.getTransactionManager();
    }

    public void release() {
        if (this.released.getAndSet(true)) {
            throw EjbLogger.ROOT_LOGGER.messageEndpointAlreadyReleasedISE(this);
        }
        this.service.release(this.delegate);
    }
}

