/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.DefaultSerializationContext;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.marshalling.protostream.SerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.modules.ModuleClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.reflect.ProxyMarshaller;
import org.wildfly.extension.clustering.web.JBossMarshallingVersion;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SessionMarshallerFactory implements Function<DeploymentUnit, ByteBufferMarshaller>
{
    JBOSS{

        @Override
        public ByteBufferMarshaller apply(DeploymentUnit unit) {
            Module module = (Module)unit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            return new JBossByteBufferMarshaller(MarshallingConfigurationRepository.from((Enum)JBossMarshallingVersion.CURRENT, (Object)module), (ClassLoader)module.getClassLoader());
        }
    }
    ,
    PROTOSTREAM{

        @Override
        public ByteBufferMarshaller apply(DeploymentUnit unit) {
            Module module = (Module)unit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            SerializationContextBuilder builder = (SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)new ModuleClassLoaderMarshaller(module.getModuleLoader()), DefaultSerializationContext::new).load((ClassLoader)module.getClassLoader());
            EEModuleConfiguration configuration = (EEModuleConfiguration)unit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
            IdentityHashMap<Class, LinkedList<ViewConfiguration>> components = new IdentityHashMap<Class, LinkedList<ViewConfiguration>>();
            for (ComponentConfiguration componentConfiguration : configuration.getComponentConfigurations()) {
                for (ViewConfiguration view : componentConfiguration.getViews()) {
                    Class proxyClass = view.getProxyFactory().defineClass();
                    if (!WriteReplaceInterface.class.isAssignableFrom(proxyClass)) continue;
                    LinkedList<ViewConfiguration> views = (LinkedList<ViewConfiguration>)components.get(view.getViewClass());
                    if (views == null) {
                        views = new LinkedList<ViewConfiguration>();
                        components.put(view.getViewClass(), views);
                    }
                    views.add(view);
                }
            }
            if (!components.isEmpty()) {
                for (final Map.Entry entry : components.entrySet()) {
                    final String viewClassName = ((Class)entry.getKey()).getName();
                    StringBuilder schemaBuilder = new StringBuilder();
                    schemaBuilder.append("package ").append(viewClassName).append(';').append(System.lineSeparator());
                    for (ViewConfiguration view : (List)entry.getValue()) {
                        schemaBuilder.append("message ").append(view.getComponentConfiguration().getComponentName()).append(" { optional bytes proxy = 1; }").append(System.lineSeparator());
                    }
                    final String schema = schemaBuilder.toString();
                    builder.register((Object)new SerializationContextInitializer(){

                        public void registerSchema(SerializationContext context) {
                            context.registerProtoFiles(FileDescriptorSource.fromString((String)(viewClassName + ".proto"), (String)schema));
                        }

                        public void registerMarshallers(SerializationContext context) {
                            for (final ViewConfiguration view : (List)entry.getValue()) {
                                Class proxyClass = view.getProxyFactory().defineClass();
                                context.registerMarshaller((ProtoStreamMarshaller)new ProxyMarshaller<Object>(proxyClass){

                                    public String getTypeName() {
                                        return viewClassName + "." + view.getComponentConfiguration().getComponentName();
                                    }
                                });
                            }
                        }
                    });
                }
            }
            return new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)builder.build(), (ClassLoader)module.getClassLoader());
        }
    };

}

