/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.star.service;

import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.abstractrecord.RecordTypeManager;
import com.arjuna.ats.arjuna.coordinator.abstractrecord.RecordTypeMap;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.core.Application;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jbossts.star.logging.RESTATLogger;
import org.jboss.jbossts.star.provider.HttpResponseMapper;
import org.jboss.jbossts.star.provider.NotFoundMapper;
import org.jboss.jbossts.star.provider.TMUnavailableMapper;
import org.jboss.jbossts.star.provider.TransactionStatusMapper;
import org.jboss.jbossts.star.resource.RESTRecord;
import org.jboss.jbossts.star.service.Coordinator;
import org.jboss.logging.Logger;

@ApplicationScoped
public class TMApplication
extends Application {
    private static final Logger log = Logger.getLogger(TMApplication.class);
    HashSet<Object> singletons = new HashSet();
    Set<Class<?>> classes = new HashSet();
    private static Class<?>[] mappers = new Class[]{TMUnavailableMapper.class, TransactionStatusMapper.class, HttpResponseMapper.class, NotFoundMapper.class};
    private static Class<?>[] resourceClasses = new Class[]{Coordinator.class};

    public TMApplication(Class<?> ... extraClasses) {
        this();
        try {
            Collections.addAll(this.classes, extraClasses);
        }
        catch (Throwable e) {
            RESTATLogger.atI18NLogger.warn_jaxrsTM(e.getMessage(), e);
        }
    }

    public TMApplication() {
        try {
            if ("true".equals(System.getProperty("recovery", "false"))) {
                RecoveryManager.manager();
            }
            RecordTypeManager.manager().add(new RecordTypeMap(){

                public Class<? extends AbstractRecord> getRecordClass() {
                    return RESTRecord.class;
                }

                public int getType() {
                    return 165;
                }
            });
            Collections.addAll(this.classes, resourceClasses);
            Collections.addAll(this.classes, mappers);
        }
        catch (Throwable e) {
            RESTATLogger.atI18NLogger.warn_jaxrsTM(e.getMessage(), e);
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

