/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.Protocol;
import org.jgroups.util.DistributionSampler;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@MBean(description="Records number of messages sent/received based on size")
public class SIZE2
extends Protocol {
    protected DistributionSampler up_sampler;
    protected DistributionSampler down_sampler;
    @Property(description="List of up sizes (different buckets), e.g. \"1,100,101,500,501,1000,1001,100000\". This example creates buckets for messages sizes 1-100, 101-500, 501-1000. The last buckets simply catches all other samples, assuming a message can never be greater than  100'000 bytes")
    protected String up_sizes;
    @Property(description="List of down sizes. See description of up_sizes")
    protected String down_sizes;
    @Property(description="Defines both up_sizes and down_sizes")
    protected String sizes;
    @Property(description="When true, use Message.size(), otherwise Message.length()")
    protected boolean use_size;
    @Property(description="Whether to throw an exception when a bucket is missing, or silently drop the samplle")
    protected boolean exception_on_missing_bucket;

    @ManagedAttribute(description="Total number of down samples", type=AttributeType.SCALAR)
    public long numDownSamples() {
        return this.down_sampler != null ? this.down_sampler.total() : 0L;
    }

    @ManagedAttribute(description="Total number of up samples", type=AttributeType.SCALAR)
    public long numUpSamples() {
        return this.up_sampler != null ? this.up_sampler.total() : 0L;
    }

    @Override
    public void init() throws Exception {
        ArrayList<Long> l;
        List<String> list;
        super.init();
        if (this.sizes != null) {
            if (this.up_sizes == null) {
                this.up_sizes = this.sizes;
            }
            if (this.down_sizes == null) {
                this.down_sizes = this.sizes;
            }
        }
        if (this.up_sizes != null) {
            list = Util.parseCommaDelimitedStrings(this.up_sizes);
            l = new ArrayList<Long>(list.size());
            for (String s : list) {
                l.add(Long.parseLong(s));
            }
            this.up_sampler = new DistributionSampler(l).exceptionOnMissingBucket(this.exception_on_missing_bucket);
        }
        if (this.down_sizes != null) {
            list = Util.parseCommaDelimitedStrings(this.down_sizes);
            l = new ArrayList(list.size());
            for (String s : list) {
                l.add(Long.parseLong(s));
            }
            this.down_sampler = new DistributionSampler(l).exceptionOnMissingBucket(this.exception_on_missing_bucket);
        }
    }

    @Override
    public void resetStats() {
        super.resetStats();
        if (this.down_sampler != null) {
            this.down_sampler.reset();
        }
        if (this.up_sampler != null) {
            this.up_sampler.reset();
        }
    }

    @ManagedOperation(description="Dumps all down samples")
    public String dumpDownSamples() {
        return this.down_sampler != null ? this.down_sampler.toString() : "n/a";
    }

    @ManagedOperation(description="Dumps all up samples")
    public String dumpUpSamples() {
        return this.up_sampler != null ? this.up_sampler.toString() : "n/a";
    }

    @ManagedOperation(description="Dumps all (down and up) samples")
    public String dump() {
        return String.format("down:\n%s\nup:\n%s\n", this.dumpDownSamples(), this.dumpUpSamples());
    }

    @Override
    public Object down(Message msg) {
        if (this.down_sampler != null) {
            this.addSample(msg, this.down_sampler);
        }
        return this.down_prot.down(msg);
    }

    @Override
    public CompletableFuture<Object> down(Message msg, boolean async) {
        if (this.down_sampler != null) {
            this.addSample(msg, this.down_sampler);
        }
        return this.down_prot.down(msg, async);
    }

    @Override
    public Object up(Message msg) {
        if (this.up_sampler != null) {
            this.addSample(msg, this.up_sampler);
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        if (this.up_sampler != null) {
            for (Message msg : batch) {
                this.addSample(msg, this.up_sampler);
            }
        }
        this.up_prot.up(batch);
    }

    protected void addSample(Message msg, DistributionSampler ds) {
        int sample = this.use_size ? msg.size() : msg.getLength();
        ds.add(sample);
    }
}

