/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl;

import java.util.EnumSet;
import java.util.Map;
import org.infinispan.CoreModule;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.lock.api.ClusteredLockManager;
import org.infinispan.lock.configuration.ClusteredLockManagerConfiguration;
import org.infinispan.lock.configuration.ClusteredLockManagerConfigurationBuilder;
import org.infinispan.lock.configuration.Reliability;
import org.infinispan.lock.impl.entries.ClusteredLockKey;
import org.infinispan.lock.impl.entries.ClusteredLockValue;
import org.infinispan.lock.impl.functions.IsLocked;
import org.infinispan.lock.impl.functions.LockFunction;
import org.infinispan.lock.impl.functions.UnlockFunction;
import org.infinispan.lock.impl.lock.ClusteredLockFilter;
import org.infinispan.lock.impl.manager.EmbeddedClusteredLockManager;
import org.infinispan.lock.logging.Log;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.TransactionMode;

@InfinispanModule(name="clustered-lock", requiredModules={"core"})
public class ClusteredLockModuleLifecycle
implements ModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(ClusteredLockModuleLifecycle.class, Log.class);
    public static final String CLUSTERED_LOCK_CACHE_NAME = "org.infinispan.LOCKS";

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        CoreModule.startLifecycleComponent((GlobalComponentRegistry)gcr, (Class[])new Class[]{ClusteredLockManager.class});
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        CoreModule.stopLifecycleComponent((GlobalComponentRegistry)gcr, (Class[])new Class[]{ClusteredLockManager.class});
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        if (!globalConfiguration.isClustered()) {
            log.configurationNotClustered();
            return;
        }
        Map externalizerMap = globalConfiguration.serialization().advancedExternalizers();
        externalizerMap.put(ClusteredLockKey.EXTERNALIZER.getId(), ClusteredLockKey.EXTERNALIZER);
        externalizerMap.put(ClusteredLockValue.EXTERNALIZER.getId(), ClusteredLockValue.EXTERNALIZER);
        externalizerMap.put(LockFunction.EXTERNALIZER.getId(), LockFunction.EXTERNALIZER);
        externalizerMap.put(UnlockFunction.EXTERNALIZER.getId(), UnlockFunction.EXTERNALIZER);
        externalizerMap.put(IsLocked.EXTERNALIZER.getId(), IsLocked.EXTERNALIZER);
        externalizerMap.put(ClusteredLockFilter.EXTERNALIZER.getId(), ClusteredLockFilter.EXTERNALIZER);
        ClusteredLockManagerConfiguration config = ClusteredLockModuleLifecycle.extractConfiguration(gcr);
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class);
        Configuration lockConfig = ClusteredLockModuleLifecycle.createClusteredLockCacheConfiguration(config, globalConfiguration);
        internalCacheRegistry.registerInternalCache(CLUSTERED_LOCK_CACHE_NAME, lockConfig, EnumSet.of(InternalCacheRegistry.Flag.EXCLUSIVE));
        ClusteredLockModuleLifecycle.registerClusteredLockManager((BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class), globalConfiguration, config);
    }

    private static ClusteredLockManagerConfiguration extractConfiguration(GlobalComponentRegistry globalComponentRegistry) {
        ClusteredLockManagerConfiguration config = (ClusteredLockManagerConfiguration)globalComponentRegistry.getGlobalConfiguration().module(ClusteredLockManagerConfiguration.class);
        return config == null ? ClusteredLockManagerConfigurationBuilder.defaultConfiguration() : config;
    }

    private static Configuration createClusteredLockCacheConfiguration(ClusteredLockManagerConfiguration config, GlobalConfiguration globalConfig) {
        int numOwners;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        if (config.numOwners() > 0) {
            builder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(config.numOwners());
        } else {
            builder.clustering().cacheMode(CacheMode.REPL_SYNC);
            if (globalConfig.isZeroCapacityNode()) {
                log.warn("When the node is configured as a zero-capacity node, you need to specify the number of owners for the lock");
            }
        }
        int n = numOwners = config.numOwners() < 0 ? ((Integer)HashConfiguration.NUM_OWNERS.getDefaultValue()).intValue() : config.numOwners();
        if (config.reliability() == Reliability.CONSISTENT && numOwners > 1) {
            builder.clustering().partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        } else {
            builder.clustering().partitionHandling().whenSplit(PartitionHandling.ALLOW_READ_WRITES);
        }
        return builder.build();
    }

    private static void registerClusteredLockManager(BasicComponentRegistry registry, GlobalConfiguration globalConfig, ClusteredLockManagerConfiguration config) {
        EmbeddedClusteredLockManager clusteredLockManager = new EmbeddedClusteredLockManager(config);
        registry.registerComponent(ClusteredLockManager.class, (Object)clusteredLockManager, true);
        if (globalConfig.jmx().enabled()) {
            try {
                CacheManagerJmxRegistration jmxRegistration = (CacheManagerJmxRegistration)registry.getComponent(CacheManagerJmxRegistration.class).running();
                jmxRegistration.registerMBean((Object)clusteredLockManager);
            }
            catch (Exception e) {
                throw log.jmxRegistrationFailed(e);
            }
        }
    }
}

