/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.common.util;

import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import org.infinispan.cdi.common.util.Reflections;

public class ImmutableInjectionPoint
implements InjectionPoint {
    private final Annotated annotated;
    private final Member member;
    private final Bean<?> declaringBean;
    private final Set<Annotation> qualifiers;
    private final Type type;
    private final boolean _transient;
    private final boolean delegate;

    public ImmutableInjectionPoint(AnnotatedField<?> field, Set<Annotation> qualifiers, Bean<?> declaringBean, boolean _transient, boolean delegate) {
        this.annotated = field;
        this.member = field.getJavaMember();
        this.qualifiers = Set.copyOf(qualifiers);
        this.type = field.getJavaMember().getGenericType();
        this._transient = _transient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
    }

    public ImmutableInjectionPoint(AnnotatedField<?> field, BeanManager beanManager, Bean<?> declaringBean, boolean _transient, boolean delegate) {
        this.annotated = field;
        this.member = field.getJavaMember();
        this.qualifiers = Reflections.getQualifiers(beanManager, (Iterable<Annotation>)field.getAnnotations());
        this.type = field.getJavaMember().getGenericType();
        this._transient = _transient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
    }

    public ImmutableInjectionPoint(AnnotatedParameter<?> parameter, Set<Annotation> qualifiers, Bean<?> declaringBean, boolean _transient, boolean delegate) {
        this.annotated = parameter;
        this.member = parameter.getDeclaringCallable().getJavaMember();
        this.qualifiers = Set.copyOf(qualifiers);
        this._transient = _transient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
        this.type = parameter.getBaseType();
    }

    public ImmutableInjectionPoint(AnnotatedParameter<?> parameter, BeanManager beanManager, Bean<?> declaringBean, boolean _transient, boolean delegate) {
        this.annotated = parameter;
        this.member = parameter.getDeclaringCallable().getJavaMember();
        this.qualifiers = Reflections.getQualifiers(beanManager, (Iterable<Annotation>)parameter.getAnnotations());
        this._transient = _transient;
        this.delegate = delegate;
        this.declaringBean = declaringBean;
        this.type = parameter.getBaseType();
    }

    public Annotated getAnnotated() {
        return this.annotated;
    }

    public Bean<?> getBean() {
        return this.declaringBean;
    }

    public Member getMember() {
        return this.member;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public boolean isTransient() {
        return this._transient;
    }
}

