/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.function.Function;
import org.jboss.as.clustering.jgroups.auth.BinaryAuthToken;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenResourceDefinitionRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.subsystem.resource.AttributeDefinitionProvider;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;

public class DigestAuthTokenResourceDefinitionRegistrar
extends AuthTokenResourceDefinitionRegistrar<BinaryAuthToken> {
    DigestAuthTokenResourceDefinitionRegistrar() {
        super(AuthTokenResourceDefinitionRegistrar.Token.DIGEST);
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)builder.provideAttributes(EnumSet.allOf(Attribute.class));
    }

    public ServiceDependency<Function<byte[], BinaryAuthToken>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final String algorithm = Attribute.ALGORITHM.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return ServiceDependency.of((Object)new Function<byte[], BinaryAuthToken>(){

            @Override
            public BinaryAuthToken apply(byte[] secret) {
                try {
                    MessageDigest digest = MessageDigest.getInstance(algorithm);
                    return new BinaryAuthToken(digest.digest(secret));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }

    static enum Attribute implements AttributeDefinitionProvider
    {
        ALGORITHM("algorithm", ModelType.STRING, new ModelNode("SHA-256"));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setDefaultValue(defaultValue)).setRequired(defaultValue == null)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition get() {
            return this.definition;
        }
    }
}

