/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.elytron.web.undertow.server.ElytronContextAssociationHandler;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.extension.undertow.CookieConfig;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.session.AffinitySessionConfigWrapper;
import org.wildfly.extension.undertow.session.AffinitySessionIdentifierCodec;
import org.wildfly.extension.undertow.session.CodecSessionConfigWrapper;
import org.wildfly.extension.undertow.session.NonDistributableSessionAffinityProvider;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;

final class HttpInvokerHostService
implements Service {
    private final Supplier<Host> host;
    private final Supplier<HttpAuthenticationFactory> httpAuthenticationFactory;
    private final Supplier<PathHandler> remoteHttpInvokerService;
    private final String path;

    HttpInvokerHostService(Supplier<Host> host, Supplier<HttpAuthenticationFactory> httpAuthenticationFactory, Supplier<PathHandler> remoteHttpInvokerService, String path) {
        this.host = host;
        this.httpAuthenticationFactory = httpAuthenticationFactory;
        this.remoteHttpInvokerService = remoteHttpInvokerService;
        this.path = path;
    }

    public void start(StartContext startContext) {
        HttpHandler handler = (HttpHandler)this.remoteHttpInvokerService.get();
        if (this.httpAuthenticationFactory != null) {
            handler = HttpInvokerHostService.secureAccess(handler, this.httpAuthenticationFactory.get());
        }
        SessionCookieConfig sessionConfig = new SessionCookieConfig();
        sessionConfig.setPath(this.path);
        Server server = this.host.get().getServer();
        ServletContainerService container = server.getServletContainer();
        CookieConfig affinityCookeConfig = container.getAffinityCookieConfig();
        CookieConfig sessionCookieConfig = container.getSessionCookieConfig();
        if (sessionCookieConfig != null) {
            if (sessionCookieConfig.getDomain() != null) {
                sessionConfig.setDomain(sessionCookieConfig.getDomain());
            }
            if (sessionCookieConfig.getMaxAge() != null) {
                sessionConfig.setMaxAge(sessionCookieConfig.getMaxAge().intValue());
            }
            if (sessionCookieConfig.getSecure() != null) {
                sessionConfig.setSecure(sessionCookieConfig.getSecure().booleanValue());
            }
            if (sessionCookieConfig.getHttpOnly() != null) {
                sessionConfig.setHttpOnly(sessionCookieConfig.getHttpOnly().booleanValue());
            }
        }
        NonDistributableSessionAffinityProvider affinityProvider = new NonDistributableSessionAffinityProvider(server);
        Object wrapper = affinityCookeConfig != null ? new AffinitySessionConfigWrapper(affinityCookeConfig, affinityProvider) : new CodecSessionConfigWrapper(new AffinitySessionIdentifierCodec(affinityProvider));
        handler = this.setupRoutes(handler, wrapper.wrap((SessionConfig)sessionConfig, null));
        this.host.get().registerHandler(this.path, handler);
        this.host.get().registerLocation(this.path);
    }

    public void stop(StopContext stopContext) {
        this.host.get().unregisterHandler(this.path);
        this.host.get().unregisterLocation(this.path);
    }

    private HttpHandler setupRoutes(HttpHandler handler, SessionConfig sessionConfig) {
        SecureRandomSessionIdGenerator generator = new SecureRandomSessionIdGenerator();
        return exchange -> {
            exchange.addResponseCommitListener(ex -> {
                String id = sessionConfig.findSessionId(exchange);
                if (id != null) {
                    sessionConfig.setSessionId(exchange, id);
                } else if (ex.getStatusCode() == 401) {
                    sessionConfig.setSessionId(exchange, generator.createSessionId());
                }
            });
            handler.handleRequest(exchange);
        };
    }

    private static HttpHandler secureAccess(HttpHandler domainHandler, HttpAuthenticationFactory httpAuthenticationFactory) {
        domainHandler = new AuthenticationCallHandler(domainHandler);
        domainHandler = new AuthenticationConstraintHandler(domainHandler);
        Supplier<List> mechanismSupplier = () -> httpAuthenticationFactory.getMechanismNames().stream().map(s -> {
            try {
                return (HttpServerAuthenticationMechanism)httpAuthenticationFactory.createMechanism(s);
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.toList());
        domainHandler = ElytronContextAssociationHandler.builder().setNext(domainHandler).setMechanismSupplier(mechanismSupplier).setHttpExchangeSupplier(h -> new ElytronHttpExchange((HttpServerExchange)h, (HttpServerExchange)h){
            final /* synthetic */ HttpServerExchange val$h;
            {
                this.val$h = httpServerExchange2;
                super(httpServerExchange);
            }

            public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
                super.authenticationComplete(securityIdentity, mechanismName);
                this.val$h.putAttachment(ElytronIdentityHandler.IDENTITY_KEY, (Object)securityIdentity);
            }
        }).build();
        return domainHandler;
    }

    public String getPath() {
        return this.path;
    }
}

