/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import io.undertow.server.protocol.proxy.ProxyProtocolOpenListener;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.deployment.DelegatingSupplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public abstract class ListenerService
implements Service<UndertowListener>,
UndertowListener {
    protected static final OptionMap commonOptions = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).set(Options.BALANCING_TOKENS, 1).set(Options.BALANCING_CONNECTIONS, 2).getMap();
    protected Consumer<ListenerService> serviceConsumer;
    protected final DelegatingSupplier<XnioWorker> worker = new DelegatingSupplier();
    protected final DelegatingSupplier<SocketBinding> binding = new DelegatingSupplier();
    protected final DelegatingSupplier<SocketBinding> redirectSocket = new DelegatingSupplier();
    protected final DelegatingSupplier<ByteBufferPool> bufferPool = new DelegatingSupplier();
    protected final DelegatingSupplier<Server> serverService = new DelegatingSupplier();
    private final List<HandlerWrapper> listenerHandlerWrappers = new ArrayList<HandlerWrapper>();
    private final String name;
    protected final OptionMap listenerOptions;
    protected final OptionMap socketOptions;
    protected volatile OpenListener openListener;
    private volatile boolean enabled;
    private volatile boolean started;
    private Consumer<Boolean> statisticsChangeListener;
    private final boolean proxyProtocol;
    private volatile HandlerWrapper stoppingWrapper;

    protected ListenerService(Consumer<ListenerService> serviceConsumer, String name, OptionMap listenerOptions, OptionMap socketOptions, boolean proxyProtocol) {
        this.serviceConsumer = serviceConsumer;
        this.name = name;
        this.listenerOptions = listenerOptions;
        this.socketOptions = socketOptions;
        this.proxyProtocol = proxyProtocol;
    }

    public DelegatingSupplier<XnioWorker> getWorker() {
        return this.worker;
    }

    public DelegatingSupplier<SocketBinding> getBinding() {
        return this.binding;
    }

    public DelegatingSupplier<SocketBinding> getRedirectSocket() {
        return this.redirectSocket;
    }

    public DelegatingSupplier<ByteBufferPool> getBufferPool() {
        return this.bufferPool;
    }

    public DelegatingSupplier<Server> getServerService() {
        return this.serverService;
    }

    protected UndertowService getUndertowService() {
        return ((Server)this.serverService.get()).getUndertowService();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Server getServer() {
        return (Server)this.serverService.get();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected UndertowXnioSsl getSsl() {
        return null;
    }

    protected OptionMap getSSLOptions(SSLContext sslContext) {
        return OptionMap.EMPTY;
    }

    public synchronized void setEnabled(boolean enabled) {
        if (this.started && enabled != this.enabled) {
            if (enabled) {
                InetSocketAddress socketAddress = ((SocketBinding)this.binding.get()).getSocketAddress();
                ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
                try {
                    this.startListening((XnioWorker)this.worker.get(), socketAddress, (ChannelListener<AcceptingChannel<StreamConnection>>)acceptListener);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.stopListening();
            }
        }
        this.enabled = enabled;
    }

    @Override
    public abstract boolean isSecure();

    protected void registerBinding() {
        ((SocketBinding)this.binding.get()).getSocketBindings().getNamedRegistry().registerBinding((ManagedBinding)new ListenerBinding((SocketBinding)this.binding.get()));
    }

    protected void unregisterBinding() {
        SocketBinding binding = (SocketBinding)this.binding.get();
        binding.getSocketBindings().getNamedRegistry().unregisterBinding(binding.getName());
    }

    protected abstract void preStart(StartContext var1);

    public void start(StartContext context) throws StartException {
        this.started = true;
        this.preStart(context);
        ((Server)this.serverService.get()).registerListener(this);
        this.openListener = this.createOpenListener();
        HttpHandler handler = ((Server)this.serverService.get()).getRoot();
        for (HandlerWrapper wrapper : this.listenerHandlerWrappers) {
            handler = wrapper.wrap(handler);
        }
        this.openListener.setRootHandler(handler);
        this.registerBinding();
        this.statisticsChangeListener = enabled -> {
            OptionMap options = this.openListener.getUndertowOptions();
            OptionMap.Builder builder = OptionMap.builder().addAll(options);
            builder.set(UndertowOptions.ENABLE_STATISTICS, enabled);
            this.openListener.setUndertowOptions(builder.getMap());
        };
        this.getUndertowService().registerStatisticsListener(this.statisticsChangeListener);
        final ServiceContainer container = context.getController().getServiceContainer();
        this.stoppingWrapper = new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return exchange -> {
                    if (container.isShutdown()) {
                        exchange.setStatusCode(503);
                        return;
                    }
                    handler.handleRequest(exchange);
                };
            }
        };
        this.addWrapperHandler(this.stoppingWrapper);
        this.serviceConsumer.accept(this);
        if (this.enabled) {
            try {
                ChannelListener acceptListener;
                InetSocketAddress socketAddress = ((SocketBinding)this.binding.get()).getSocketAddress();
                if (this.proxyProtocol) {
                    UndertowXnioSsl xnioSsl = this.getSsl();
                    acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)new ProxyProtocolOpenListener(this.openListener, xnioSsl, (ByteBufferPool)this.bufferPool.get(), xnioSsl != null ? this.getSSLOptions(xnioSsl.getSslContext()) : null));
                } else {
                    acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
                }
                this.startListening((XnioWorker)this.worker.get(), socketAddress, (ChannelListener<AcceptingChannel<StreamConnection>>)acceptListener);
            }
            catch (IOException e) {
                this.cleanFailedStart();
                try {
                    this.stop();
                }
                catch (Exception acceptListener) {
                    // empty catch block
                }
                if (e instanceof BindException) {
                    StringBuilder sb = new StringBuilder().append(e.getLocalizedMessage());
                    InetSocketAddress socketAddress = ((SocketBinding)this.binding.get()).getSocketAddress();
                    if (socketAddress != null) {
                        sb.append(" ").append(socketAddress);
                    }
                    throw new StartException(sb.toString());
                }
                throw UndertowLogger.ROOT_LOGGER.couldNotStartListener(this.name, e);
            }
        }
    }

    protected abstract void cleanFailedStart();

    public void stop(StopContext context) {
        this.stop();
    }

    private void stop() {
        if (this.enabled) {
            this.stopListening();
        }
        this.serviceConsumer.accept(null);
        this.started = false;
        ((Server)this.serverService.get()).unregisterListener(this);
        this.unregisterBinding();
        this.getUndertowService().unregisterStatisticsListener(this.statisticsChangeListener);
        this.statisticsChangeListener = null;
        this.listenerHandlerWrappers.remove(this.stoppingWrapper);
        this.stoppingWrapper = null;
    }

    void addWrapperHandler(HandlerWrapper wrapper) {
        this.listenerHandlerWrappers.add(wrapper);
    }

    public OpenListener getOpenListener() {
        return this.openListener;
    }

    protected abstract OpenListener createOpenListener();

    abstract void startListening(XnioWorker var1, InetSocketAddress var2, ChannelListener<AcceptingChannel<StreamConnection>> var3) throws IOException;

    abstract void stopListening();

    @Override
    public abstract String getProtocol();

    @Override
    public boolean isShutdown() {
        DelegatingSupplier<XnioWorker> workerSupplier = this.getWorker();
        XnioWorker worker = workerSupplier != null ? (XnioWorker)workerSupplier.get() : null;
        return worker == null || worker.isShutdown();
    }

    @Override
    public SocketBinding getSocketBinding() {
        return (SocketBinding)this.binding.get();
    }

    private static class ListenerBinding
    implements ManagedBinding {
        private final SocketBinding binding;

        private ListenerBinding(SocketBinding binding) {
            this.binding = binding;
        }

        public String getSocketBindingName() {
            return this.binding.getName();
        }

        public InetSocketAddress getBindAddress() {
            return this.binding.getSocketAddress();
        }

        public void close() throws IOException {
        }
    }
}

