/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.staticlist;

import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.api.config.ServiceDiscoveryAttribute;
import io.smallrye.stork.api.config.ServiceDiscoveryAttributes;
import io.smallrye.stork.api.config.ServiceDiscoveryType;
import io.smallrye.stork.impl.DefaultServiceInstance;
import io.smallrye.stork.servicediscovery.staticlist.StaticConfiguration;
import io.smallrye.stork.servicediscovery.staticlist.StaticListServiceDiscovery;
import io.smallrye.stork.spi.ServiceDiscoveryProvider;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.smallrye.stork.utils.HostAndPort;
import io.smallrye.stork.utils.InMemoryAddressesBackend;
import io.smallrye.stork.utils.ServiceInstanceIds;
import io.smallrye.stork.utils.StorkAddressUtils;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.Collections;

@ServiceDiscoveryType(value="static")
@ServiceDiscoveryAttributes(value={@ServiceDiscoveryAttribute(name="address-list", description="A comma-separated list of addresses (host:port). The default port is 80.", required=true), @ServiceDiscoveryAttribute(name="secure", description="Whether the connection with the service should be encrypted with TLS. Default is false, except if the host:port uses the port is 443."), @ServiceDiscoveryAttribute(name="shuffle", description="Whether the list of address must be shuffled to avoid using the first address on every startup.", defaultValue="false")})
@ApplicationScoped
public class StaticListServiceDiscoveryProvider
implements ServiceDiscoveryProvider<StaticConfiguration> {
    public ServiceDiscovery createServiceDiscovery(StaticConfiguration config, String serviceName, ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
        String addresses = config.getAddressList();
        ArrayList<DefaultServiceInstance> addressList = new ArrayList<DefaultServiceInstance>();
        if (addresses != null && !addresses.isBlank()) {
            for (String address : addresses.split(",")) {
                address = address.trim();
                try {
                    HostAndPort hostAndPort = StorkAddressUtils.parseToHostAndPort((String)address, (int)(address.startsWith("https://") ? 443 : 80), (String)("service '" + serviceName + "'"));
                    addressList.add(new DefaultServiceInstance(ServiceInstanceIds.next().longValue(), hostAndPort.host, hostAndPort.port, hostAndPort.path, this.isSecure(config.getSecure(), hostAndPort.port)));
                    InMemoryAddressesBackend.add((String)serviceName, (String)address);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Address not parseable to URL: " + address + " for service " + serviceName);
                }
            }
            if (Boolean.parseBoolean(config.getShuffle())) {
                Collections.shuffle(addressList);
            }
        }
        return new StaticListServiceDiscovery(serviceName, addressList);
    }

    private boolean isSecure(String secureAttribute, int port) {
        if (secureAttribute == null) {
            return port == 443;
        }
        return Boolean.parseBoolean(secureAttribute);
    }
}

