/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class JndiHelper {
    private static final String CONFIGURED_JMS_PROTOCOLS = "jms.protocols";
    private static final String DEFAULT_JMS_PROTOCOLS = "vm,tcp,nio,ssl,http,https,ws,wss";
    private static final List<String> ALLOWED_PROTOCOLS;
    private Properties environment;

    public JndiHelper(Properties environment) {
        this.environment = environment;
        String providerUrl = environment.getProperty("java.naming.provider.url");
        if (providerUrl != null && !providerUrl.isEmpty()) {
            if (!ALLOWED_PROTOCOLS.stream().anyMatch(providerUrl::startsWith)) {
                throw new IllegalArgumentException("Unsafe protocol in JNDI URL: " + providerUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lookup(String name, Class<T> requiredType) throws NamingException {
        InitialContext ctx = new InitialContext(this.environment);
        try {
            Object located = ctx.lookup(name);
            if (located == null) {
                throw new NameNotFoundException("JNDI object with [" + name + "] not found");
            }
            Object object = located;
            return (T)object;
        }
        finally {
            ResourceCloser.close(ctx);
        }
    }

    static {
        String jmsProtocols = SystemPropertyAction.getProperty((String)CONFIGURED_JMS_PROTOCOLS, (String)DEFAULT_JMS_PROTOCOLS);
        if (StringUtils.isEmpty((String)jmsProtocols)) {
            ALLOWED_PROTOCOLS = Collections.emptyList();
        } else {
            ArrayList allowedProtocols = new ArrayList();
            Arrays.stream(jmsProtocols.split(",")).map(String::trim).filter(Predicate.not(String::isEmpty)).map(s -> s + "://").forEach(allowedProtocols::add);
            ALLOWED_PROTOCOLS = Collections.unmodifiableList(allowedProtocols);
        }
    }
}

