/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.helpers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Message;

public class MultiUtils {
    public static <T> Multi<T> createFromGenerator(Supplier<T> supplier) {
        return Multi.createFrom().generator(() -> null, (s, g) -> {
            g.emit(supplier.get());
            return s;
        });
    }

    public static <T> Multi<T> publisher(Flow.Publisher<T> publisher) {
        Flow.Publisher actual = (Flow.Publisher)ParameterValidation.nonNull(publisher, (String)"publisher");
        if (actual instanceof Multi) {
            return (Multi)actual;
        }
        return Multi.createFrom().safePublisher(publisher);
    }

    public static Multi<? extends Message<?>> handlePreProcessingAcknowledgement(Multi<? extends Message<?>> multi, MediatorConfiguration configuration) {
        if (configuration.getAcknowledgment() != Acknowledgment.Strategy.PRE_PROCESSING) {
            return multi;
        }
        return multi.plug(stream -> stream.onItem().transformToUni(message -> {
            CompletionStage ack = message.ack();
            return Uni.createFrom().completionStage(ack).map(x -> message);
        }).concatenate(true));
    }

    public static <T, R> Multi<R> via(Multi<T> multi, Flow.Processor<? super T, ? super R> processor) {
        return multi.plug(stream -> Multi.createFrom().deferred(() -> {
            Multi m = MultiUtils.publisher(processor);
            stream.subscribe((Flow.Subscriber)processor);
            return m;
        }));
    }

    public static <T, R, P> Flow.Subscriber<T> via(final Flow.Processor<T, R> processor, final Function<Multi<R>, Multi<P>> function) {
        return new MultiSubscriber<T>(){

            public void onSubscribe(Flow.Subscription subscription) {
                processor.onSubscribe(subscription);
                MultiUtils.publisher(processor).plug(function).subscribe().with(r -> {});
            }

            public void onItem(T item) {
                processor.onNext(item);
            }

            public void onFailure(Throwable throwable) {
                processor.onError(throwable);
            }

            public void onCompletion() {
                processor.onComplete();
            }
        };
    }

    public static <T, R> Flow.Subscriber<T> via(Function<Multi<T>, Multi<R>> function) {
        return MultiUtils.via(NoopProcessor.create(), function);
    }

    public static class NoopProcessor<T>
    extends AbstractMulti<T>
    implements Flow.Processor<T, T>,
    Flow.Subscription {
        private volatile boolean done = false;
        private volatile boolean cancelled = false;
        private volatile Flow.Subscription upstream = null;
        private static final AtomicReferenceFieldUpdater<NoopProcessor, Flow.Subscription> UPSTREAM_UPDATER = AtomicReferenceFieldUpdater.newUpdater(NoopProcessor.class, Flow.Subscription.class, "upstream");
        private volatile Flow.Subscriber<? super T> downstream = null;
        private static final AtomicReferenceFieldUpdater<NoopProcessor, Flow.Subscriber> DOWNSTREAM_UPDATER = AtomicReferenceFieldUpdater.newUpdater(NoopProcessor.class, Flow.Subscriber.class, "downstream");

        public static <I> NoopProcessor<I> create() {
            return new NoopProcessor();
        }

        private NoopProcessor() {
        }

        @Override
        public void subscribe(MultiSubscriber<? super T> downstream) {
            ParameterValidation.nonNull(downstream, (String)"downstream");
            if (DOWNSTREAM_UPDATER.compareAndSet(this, (Flow.Subscriber)null, (Flow.Subscriber)downstream)) {
                if (this.upstream != null) {
                    downstream.onSubscribe((Flow.Subscription)this);
                }
            } else {
                Subscriptions.fail(downstream, (Throwable)new IllegalStateException("Already subscribed"));
            }
        }

        @Override
        public void onSubscribe(Flow.Subscription upstream) {
            if (this.isDoneOrCancelled() || !UPSTREAM_UPDATER.compareAndSet(this, null, upstream)) {
                upstream.cancel();
                return;
            }
            Flow.Subscriber<T> subscriber = this.downstream;
            if (subscriber != null) {
                subscriber.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.isDoneOrCancelled()) {
                return;
            }
            Flow.Subscriber<T> subscriber = this.downstream;
            if (subscriber != null) {
                subscriber.onNext(t);
            }
        }

        private boolean isDoneOrCancelled() {
            return this.done || this.cancelled;
        }

        @Override
        public void onError(Throwable failure) {
            Objects.requireNonNull(failure);
            if (this.isDoneOrCancelled()) {
                return;
            }
            this.done = true;
            Flow.Subscriber<T> subscriber = this.downstream;
            if (subscriber != null) {
                subscriber.onError(failure);
            }
        }

        @Override
        public void onComplete() {
            if (this.isDoneOrCancelled()) {
                return;
            }
            this.done = true;
            Flow.Subscriber<T> subscriber = this.downstream;
            if (subscriber != null) {
                subscriber.onComplete();
            }
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                UPSTREAM_UPDATER.get(this).request(n);
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            DOWNSTREAM_UPDATER.getAndSet(this, null);
        }
    }
}

