/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.tool;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.patching.ContentConflictsException;
import org.jboss.as.patching.PatchInfo;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.VerbosePatchInfo;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElement;
import org.jboss.as.patching.tool.ContentPolicyBuilderImpl;
import org.jboss.as.patching.tool.ContentVerificationPolicy;
import org.jboss.as.patching.tool.PatchTool;
import org.jboss.as.patching.tool.PatchingHistory;
import org.jboss.as.patching.tool.PatchingResult;
import org.jboss.dmr.ModelNode;
import org.wildfly.common.Assert;

public abstract class PatchOperationTarget {
    static final PathElement CORE_SERVICES = PathElement.pathElement((String)"core-service", (String)"patching");

    public static final PatchOperationTarget createLocal(File jbossHome, List<File> moduleRoots, List<File> bundlesRoots) throws IOException {
        PatchTool tool = PatchTool.Factory.createLocalTool(jbossHome, moduleRoots, bundlesRoots);
        return new LocalPatchOperationTarget(tool);
    }

    public static final PatchOperationTarget createStandalone(ModelControllerClient controllerClient) {
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{CORE_SERVICES});
        return new RemotePatchOperationTarget(address, controllerClient);
    }

    public static final PatchOperationTarget createHost(String hostName, ModelControllerClient client) {
        PathElement host = PathElement.pathElement((String)"host", (String)hostName);
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{host, CORE_SERVICES});
        return new RemotePatchOperationTarget(address, client);
    }

    protected abstract ModelNode streams() throws PatchingException;

    protected abstract ModelNode info() throws PatchingException;

    protected abstract ModelNode info(String var1) throws PatchingException;

    protected abstract ModelNode info(String var1, boolean var2) throws PatchingException;

    protected abstract ModelNode info(String var1, String var2, boolean var3) throws PatchingException;

    protected ModelNode history() throws PatchingException {
        return this.history(false);
    }

    protected abstract ModelNode history(boolean var1) throws PatchingException;

    protected ModelNode history(String streamName) throws PatchingException {
        return this.history(streamName, false);
    }

    protected abstract ModelNode history(String var1, boolean var2) throws PatchingException;

    protected abstract ModelNode applyPatch(File var1, ContentPolicyBuilderImpl var2) throws PatchingException;

    protected abstract ModelNode rollback(String var1, ContentPolicyBuilderImpl var2, boolean var3, boolean var4) throws PatchingException;

    protected abstract ModelNode rollback(String var1, String var2, ContentPolicyBuilderImpl var3, boolean var4, boolean var5) throws PatchingException;

    protected abstract ModelNode rollbackLast(ContentPolicyBuilderImpl var1, boolean var2) throws PatchingException;

    protected abstract ModelNode rollbackLast(String var1, ContentPolicyBuilderImpl var2, boolean var3) throws PatchingException;

    static ModelNode formatFailedResponse(String msg) {
        ModelNode result = new ModelNode();
        result.get("outcome").set("failed");
        result.get(new String[]{"failure-description", "message"}).set(msg);
        return result;
    }

    static ModelNode formatFailedResponse(PatchingException e) {
        ModelNode result = new ModelNode();
        result.get("outcome").set("failed");
        PatchOperationTarget.formatFailedResponse(e, result.get("failure-description"));
        return result;
    }

    public static void formatFailedResponse(PatchingException e, ModelNode failureDescription) {
        if (e instanceof ContentConflictsException) {
            failureDescription.get("message").set(PatchLogger.ROOT_LOGGER.detectedConflicts());
            ModelNode conflicts = failureDescription.get("conflicts");
            for (ContentItem item : ((ContentConflictsException)e).getConflicts()) {
                ContentType type = item.getContentType();
                switch (type) {
                    case BUNDLE: {
                        conflicts.get("bundles").add(item.getRelativePath());
                        break;
                    }
                    case MODULE: {
                        conflicts.get("modules").add(item.getRelativePath());
                        break;
                    }
                    case MISC: {
                        conflicts.get("misc").add(item.getRelativePath());
                    }
                }
            }
        } else {
            failureDescription.set(e.getLocalizedMessage());
        }
    }

    static ModelNode createOperation(String operationName, ModelNode addr, ContentPolicyBuilderImpl builder) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set(operationName);
        operation.get("address").set(addr);
        operation.get("override-modules").set(builder.ignoreModulesChanges);
        operation.get("override-all").set(builder.overrideAll);
        if (!builder.override.isEmpty()) {
            for (String o : builder.override) {
                operation.get("override").add(o);
            }
        }
        if (!builder.preserve.isEmpty()) {
            for (String p : builder.preserve) {
                operation.get("preserve").add(p);
            }
        }
        return operation;
    }

    protected static class LocalPatchOperationTarget
    extends PatchOperationTarget {
        private final PatchTool tool;

        public LocalPatchOperationTarget(PatchTool tool) {
            this.tool = tool;
        }

        @Override
        protected ModelNode streams() throws PatchingException {
            List<String> streams = this.tool.getPatchStreams();
            ModelNode result = new ModelNode();
            result.get("outcome").set("success");
            ModelNode list = result.get("result").setEmptyList();
            for (String stream : streams) {
                list.add(stream);
            }
            return result;
        }

        @Override
        protected ModelNode info() throws PatchingException {
            return this.info(null);
        }

        @Override
        protected ModelNode info(String streamName) throws PatchingException {
            PatchInfo info = this.tool.getPatchInfo(streamName);
            ModelNode response = new ModelNode();
            response.get("outcome").set("success");
            ModelNode result = response.get("result");
            result.get("version").set(info.getVersion());
            result.get("cumulative-patch-id").set(info.getCumulativePatchID());
            result.get("patches").setEmptyList();
            for (String patch : info.getPatchIDs()) {
                result.get("patches").add(patch);
            }
            if (info instanceof VerbosePatchInfo) {
                ModelNode layersNode;
                VerbosePatchInfo vInfo = (VerbosePatchInfo)info;
                if (vInfo.hasLayers()) {
                    layersNode = result.get("layer");
                    for (String name : vInfo.getLayerNames()) {
                        this.addLayerInfo(layersNode.get(name), vInfo.getLayerInfo(name));
                    }
                }
                if (vInfo.hasAddOns()) {
                    layersNode = result.get("add-on");
                    for (String name : vInfo.getAddOnNames()) {
                        this.addLayerInfo(layersNode.get(name), vInfo.getAddOnInfo(name));
                    }
                }
            }
            return response;
        }

        private void addLayerInfo(ModelNode layerNode, PatchableTarget.TargetInfo layerInfo) {
            layerNode.get("cumulative-patch-id").set(layerInfo.getCumulativePatchID());
            ModelNode patchesNode = layerNode.get("patches").setEmptyList();
            if (!layerInfo.getPatchIDs().isEmpty()) {
                for (String patchId : layerInfo.getPatchIDs()) {
                    patchesNode.add(patchId);
                }
            }
        }

        @Override
        protected ModelNode history(boolean excludeAgedOut) {
            return this.history(null, excludeAgedOut);
        }

        @Override
        protected ModelNode history(String streamName, boolean excludeAgedOut) {
            ModelNode result = new ModelNode();
            result.get("outcome").set("success");
            try {
                result.get("result").set(this.tool.getPatchingHistory(streamName).getHistory(excludeAgedOut));
            }
            catch (PatchingException e) {
                return LocalPatchOperationTarget.formatFailedResponse(e);
            }
            return result;
        }

        @Override
        protected ModelNode applyPatch(File file, ContentPolicyBuilderImpl builder) {
            ContentVerificationPolicy policy = builder.createPolicy();
            ModelNode result = new ModelNode();
            try {
                PatchingResult apply = this.tool.applyPatch(file, policy);
                apply.commit();
                result.get("outcome").set("success");
                result.get("result").setEmptyObject();
            }
            catch (PatchingException e) {
                return LocalPatchOperationTarget.formatFailedResponse(e);
            }
            return result;
        }

        @Override
        protected ModelNode rollback(String patchId, ContentPolicyBuilderImpl builder, boolean rollbackTo, boolean resetConfiguration) {
            return this.rollback(null, patchId, builder, rollbackTo, resetConfiguration);
        }

        @Override
        protected ModelNode rollback(String streamName, String patchId, ContentPolicyBuilderImpl builder, boolean rollbackTo, boolean resetConfiguration) {
            ContentVerificationPolicy policy = builder.createPolicy();
            ModelNode result = new ModelNode();
            try {
                PatchingResult rollback = this.tool.rollback(streamName, patchId, policy, rollbackTo, resetConfiguration);
                rollback.commit();
                result.get("outcome").set("success");
                result.get("result").setEmptyObject();
            }
            catch (PatchingException e) {
                return LocalPatchOperationTarget.formatFailedResponse(e);
            }
            return result;
        }

        @Override
        protected ModelNode rollbackLast(ContentPolicyBuilderImpl builder, boolean restoreConfiguration) {
            return this.rollbackLast(null, builder, restoreConfiguration);
        }

        @Override
        protected ModelNode rollbackLast(String streamName, ContentPolicyBuilderImpl builder, boolean restoreConfiguration) {
            ContentVerificationPolicy policy = builder.createPolicy();
            ModelNode result = new ModelNode();
            try {
                PatchingResult rollback = this.tool.rollbackLast(streamName, policy, restoreConfiguration);
                rollback.commit();
                result.get("outcome").set("success");
                result.get("result").setEmptyObject();
            }
            catch (PatchingException e) {
                return LocalPatchOperationTarget.formatFailedResponse(e);
            }
            return result;
        }

        @Override
        protected ModelNode info(String patchId, boolean verbose) throws PatchingException {
            return this.info(null, patchId, verbose);
        }

        @Override
        protected ModelNode info(String streamName, String patchId, boolean verbose) throws PatchingException {
            Assert.checkNotNullParam((String)"patchId", (Object)patchId);
            PatchingHistory history = this.tool.getPatchingHistory(streamName);
            try {
                PatchingHistory.Iterator iterator = history.iterator();
                while (iterator.hasNext()) {
                    PatchingHistory.Entry next = (PatchingHistory.Entry)iterator.next();
                    if (!patchId.equals(next.getPatchId())) continue;
                    ModelNode response = new ModelNode();
                    response.get("outcome").set("success");
                    ModelNode result = response.get("result");
                    result.get("patch-id").set(next.getPatchId());
                    result.get("type").set(next.getType().getName());
                    Patch metadata = next.getMetadata();
                    result.get("identity-name").set(metadata.getIdentity().getName());
                    result.get("identity-version").set(metadata.getIdentity().getVersion());
                    result.get("description").set(next.getMetadata().getDescription());
                    if (next.getMetadata().getLink() != null) {
                        result.get("link").set(next.getMetadata().getLink());
                    }
                    if (verbose) {
                        ModelNode elements = result.get("elements").setEmptyList();
                        for (PatchElement e : metadata.getElements()) {
                            ModelNode element = new ModelNode();
                            element.get("patch-id").set(e.getId());
                            element.get("name").set(e.getProvider().getName());
                            element.get("type").set(e.getProvider().isAddOn() ? "add-on" : "layer");
                            element.get("description").set(e.getDescription());
                            elements.add(element);
                        }
                    }
                    return response;
                }
            }
            catch (PatchingException e) {
                return LocalPatchOperationTarget.formatFailedResponse(e);
            }
            return LocalPatchOperationTarget.formatFailedResponse(PatchLogger.ROOT_LOGGER.patchNotFoundInHistory(patchId).getLocalizedMessage());
        }
    }

    protected static class RemotePatchOperationTarget
    extends PatchOperationTarget {
        private final PathAddress address;
        private final ModelControllerClient client;

        public RemotePatchOperationTarget(PathAddress address, ModelControllerClient client) {
            this.address = address;
            this.client = client;
        }

        @Override
        protected ModelNode streams() throws PatchingException {
            ModelNode operation = new ModelNode();
            operation.get("address").set(this.address.toModelNode());
            operation.get("operation").set("read-children-names");
            operation.get("child-type").set("patch-stream");
            return this.executeOp(operation);
        }

        @Override
        protected ModelNode info() throws PatchingException {
            return this.info(null);
        }

        @Override
        protected ModelNode info(String streamName) throws PatchingException {
            ModelNode operation = new ModelNode();
            operation.get("operation").set("patch-info");
            operation.get("address").set(this.address.toModelNode());
            if (streamName != null) {
                operation.get("address").add("patch-stream", streamName);
            }
            operation.get("verbose").set(true);
            return this.executeOp(operation);
        }

        @Override
        protected ModelNode history(boolean excludeAgedOut) throws PatchingException {
            return this.history(null, excludeAgedOut);
        }

        @Override
        protected ModelNode history(String streamName, boolean excludeAgedOut) throws PatchingException {
            ModelNode operation = new ModelNode();
            operation.get("operation").set("show-history");
            operation.get("address").set(this.address.toModelNode());
            if (streamName != null) {
                operation.get("address").add("patch-stream", streamName);
            }
            if (excludeAgedOut) {
                operation.get("exclude-aged-out").set(true);
            }
            return this.executeOp(operation);
        }

        @Override
        protected ModelNode applyPatch(File file, ContentPolicyBuilderImpl policyBuilder) throws PatchingException {
            ModelNode operation = RemotePatchOperationTarget.createOperation("patch", this.address.toModelNode(), policyBuilder);
            operation.get("input-stream-index").set(0);
            OperationBuilder operationBuilder = OperationBuilder.create((ModelNode)operation);
            operationBuilder.addFileAsAttachment(file);
            return this.executeOp(operationBuilder.build());
        }

        @Override
        protected ModelNode rollback(String patchId, ContentPolicyBuilderImpl builder, boolean rollbackTo, boolean resetConfiguration) throws PatchingException {
            return this.rollback(null, patchId, builder, rollbackTo, resetConfiguration);
        }

        @Override
        protected ModelNode rollback(String streamName, String patchId, ContentPolicyBuilderImpl builder, boolean rollbackTo, boolean resetConfiguration) throws PatchingException {
            ModelNode operation = RemotePatchOperationTarget.createOperation("rollback", this.address.toModelNode(), builder);
            operation.get("patch-id").set(patchId);
            operation.get("reset-configuration").set(resetConfiguration);
            operation.get("rollback-to").set(rollbackTo);
            if (streamName != null) {
                operation.get("address").add("patch-stream", streamName);
            }
            return this.executeOp(operation);
        }

        @Override
        protected ModelNode rollbackLast(ContentPolicyBuilderImpl builder, boolean restoreConfiguration) throws PatchingException {
            return this.rollbackLast(null, builder, restoreConfiguration);
        }

        @Override
        protected ModelNode rollbackLast(String streamName, ContentPolicyBuilderImpl builder, boolean restoreConfiguration) throws PatchingException {
            ModelNode operation = RemotePatchOperationTarget.createOperation("rollback-last", this.address.toModelNode(), builder);
            operation.get("reset-configuration").set(restoreConfiguration);
            if (streamName != null) {
                operation.get("address").add("patch-stream", streamName);
            }
            return this.executeOp(operation);
        }

        @Override
        protected ModelNode info(String patchId, boolean verbose) throws PatchingException {
            return this.info(null, patchId, verbose);
        }

        @Override
        protected ModelNode info(String streamName, String patchId, boolean verbose) throws PatchingException {
            ModelNode operation = new ModelNode();
            operation.get("operation").set("patch-info");
            operation.get("address").set(this.address.toModelNode());
            operation.get("patch-id").set(patchId);
            if (streamName != null) {
                operation.get("address").add("patch-stream", streamName);
            }
            if (verbose) {
                operation.get("verbose").set(true);
            }
            return this.executeOp(operation);
        }

        protected ModelNode executeOp(ModelNode operation) throws PatchingException {
            try {
                return this.client.execute(operation);
            }
            catch (IOException e) {
                throw new PatchingException("Failed to execute operation " + operation, e);
            }
        }

        protected ModelNode executeOp(Operation operation) throws PatchingException {
            try {
                return this.client.execute(operation);
            }
            catch (IOException e) {
                throw new PatchingException("Failed to execute operation " + operation.getOperation(), e);
            }
        }
    }
}

