/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.spec;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.merge.MergeUtil;

public class MethodsMetaData
extends ArrayList<MethodMetaData> {
    private static final long serialVersionUID = -1713776894150257182L;

    public boolean matches(String methodName, Class[] params, MethodInterfaceType interfaceType) {
        return this.matches(methodName, this.getParametersAsStrings(params), interfaceType);
    }

    public boolean matches(String methodName, String[] params, MethodInterfaceType interfaceType) {
        if (this.isEmpty()) {
            return false;
        }
        for (MethodMetaData method : this) {
            if (!method.matches(methodName, params, interfaceType)) continue;
            return true;
        }
        return false;
    }

    public MethodMetaData bestMatch(String methodName, Class[] params, MethodInterfaceType interfaceType, MethodMetaData bestMatch) {
        return this.bestMatch(methodName, this.getParametersAsStrings(params), interfaceType, bestMatch);
    }

    public MethodMetaData bestMatch(String methodName, String[] params, MethodInterfaceType interfaceType, MethodMetaData bestMatch) {
        if (this.isEmpty()) {
            return bestMatch;
        }
        for (MethodMetaData method : this) {
            if (!method.matches(methodName, params, interfaceType)) continue;
            if (bestMatch == null) {
                bestMatch = method;
                continue;
            }
            if ("*".equals(bestMatch.getMethodName())) {
                bestMatch = method;
                continue;
            }
            if (method.getMethodParams() == null) continue;
            bestMatch = method;
        }
        return bestMatch;
    }

    public MethodsMetaData getMethodsByEjbName(String ejbName) {
        if (ejbName == null) {
            throw new IllegalArgumentException("Null ejbName");
        }
        ArrayList result = null;
        for (MethodMetaData method : this) {
            if (!ejbName.equals(method.getEjbName())) continue;
            if (result == null) {
                result = new MethodsMetaData();
            }
            result.add(method);
        }
        return result;
    }

    private String[] getParametersAsStrings(Class[] classes) {
        if (classes == null) {
            return null;
        }
        String[] out = new String[classes.length];
        for (int i = 0; i < out.length; ++i) {
            Object brackets = "";
            Class<?> cls = classes[i];
            while (cls.isArray()) {
                brackets = (String)brackets + "[]";
                cls = cls.getComponentType();
            }
            out[i] = cls.getName() + (String)brackets;
        }
        return out;
    }

    public void merge(MethodsMetaData override, MethodsMetaData original) {
        MergeUtil.merge((Collection)this, (Collection)override, (Collection)original);
    }
}

