/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowMessages;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.channels.StreamSinkChannel;

public class AsyncSenderImpl
implements Sender {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private StreamSinkChannel channel;
    private final HttpServerExchange exchange;
    private ByteBuffer[] buffer;
    private IoCallback callback;
    private boolean inCallback;
    private final ChannelListener<StreamSinkChannel> writeListener = new ChannelListener<StreamSinkChannel>(){

        public void handleEvent(StreamSinkChannel streamSinkChannel) {
            try {
                long res;
                long toWrite = Buffers.remaining((Buffer[])AsyncSenderImpl.this.buffer);
                for (long written = 0L; written < toWrite; written += res) {
                    res = streamSinkChannel.write(AsyncSenderImpl.this.buffer, 0, AsyncSenderImpl.this.buffer.length);
                    if (res != 0L) continue;
                    return;
                }
                streamSinkChannel.suspendWrites();
                AsyncSenderImpl.this.invokeOnComplete();
            }
            catch (IOException e) {
                streamSinkChannel.suspendWrites();
                AsyncSenderImpl.this.callback.onException(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this, e);
            }
        }
    };

    public AsyncSenderImpl(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void send(ByteBuffer buffer, IoCallback callback) {
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.buffer != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        StreamSinkChannel channel = this.channel;
        if (channel == null) {
            if (callback == IoCallback.END_EXCHANGE && this.exchange.getResponseContentLength() == -1L) {
                this.exchange.setResponseContentLength(buffer.remaining());
            }
            this.channel = channel = this.exchange.getResponseChannel();
            if (channel == null) {
                throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
            }
        }
        this.callback = callback;
        if (this.inCallback) {
            this.buffer = new ByteBuffer[]{buffer};
            return;
        }
        try {
            do {
                if (buffer.remaining() == 0) {
                    callback.onComplete(this.exchange, this);
                    return;
                }
                int res = channel.write(buffer);
                if (res != 0) continue;
                this.buffer = new ByteBuffer[]{buffer};
                this.callback = callback;
                channel.getWriteSetter().set(this.writeListener);
                channel.resumeWrites();
                return;
            } while (buffer.hasRemaining());
            this.invokeOnComplete();
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(ByteBuffer[] buffer, IoCallback callback) {
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.buffer != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.callback = callback;
        if (this.inCallback) {
            this.buffer = buffer;
            return;
        }
        long totalToWrite = Buffers.remaining((Buffer[])buffer);
        StreamSinkChannel channel = this.channel;
        if (channel == null) {
            if (callback == IoCallback.END_EXCHANGE && this.exchange.getResponseContentLength() == -1L) {
                this.exchange.setResponseContentLength(totalToWrite);
            }
            this.channel = channel = this.exchange.getResponseChannel();
            if (channel == null) {
                throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
            }
        }
        long total = totalToWrite;
        long written = 0L;
        try {
            do {
                long res = channel.write(buffer);
                written += res;
                if (res != 0L) continue;
                this.buffer = buffer;
                this.callback = callback;
                channel.getWriteSetter().set(this.writeListener);
                channel.resumeWrites();
                return;
            } while (written < total);
            this.invokeOnComplete();
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(ByteBuffer buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(ByteBuffer[] buffer) {
        this.send(buffer, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data, IoCallback callback) {
        this.send(ByteBuffer.wrap(data.getBytes(utf8)), callback);
    }

    @Override
    public void send(String data, Charset charset, IoCallback callback) {
        this.send(ByteBuffer.wrap(data.getBytes(charset)), callback);
    }

    @Override
    public void send(String data) {
        this.send(data, IoCallback.END_EXCHANGE);
    }

    @Override
    public void send(String data, Charset charset) {
        this.send(data, charset, IoCallback.END_EXCHANGE);
    }

    @Override
    public void close(final IoCallback callback) {
        block8: {
            try {
                StreamSinkChannel channel = this.channel;
                if (channel == null) {
                    if (this.exchange.getResponseContentLength() == -1L) {
                        this.exchange.setResponseContentLength(0L);
                    }
                    this.channel = channel = this.exchange.getResponseChannel();
                    if (channel == null) {
                        throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
                    }
                }
                channel.shutdownWrites();
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                        public void handleEvent(StreamSinkChannel channel) {
                            callback.onComplete(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this);
                        }
                    }, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSinkChannel>(){

                        public void handleException(StreamSinkChannel channel, IOException exception) {
                            callback.onException(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this, exception);
                        }
                    }));
                    channel.resumeWrites();
                } else if (callback != null) {
                    callback.onComplete(this.exchange, this);
                }
            }
            catch (IOException e) {
                if (callback == null) break block8;
                callback.onException(this.exchange, this, e);
            }
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnComplete() {
        while (true) {
            long t;
            IoCallback callback = this.callback;
            this.buffer = null;
            this.callback = null;
            this.inCallback = true;
            try {
                callback.onComplete(this.exchange, this);
            }
            finally {
                this.inCallback = false;
            }
            StreamSinkChannel channel = this.channel;
            if (this.buffer == null) break;
            long total = t = Buffers.remaining((Buffer[])this.buffer);
            long written = 0L;
            try {
                do {
                    long res = channel.write(this.buffer);
                    written += res;
                    if (res != 0L) continue;
                    channel.getWriteSetter().set(this.writeListener);
                    channel.resumeWrites();
                    return;
                } while (written < total);
            }
            catch (IOException e) {
                callback.onException(this.exchange, this, e);
            }
        }
    }
}

