/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class HasRequestHeaderPredicate
implements Predicate {
    private final HttpString[] headers;
    private final boolean allHeaders;

    HasRequestHeaderPredicate(String[] headers, boolean allHeaders) {
        this.allHeaders = allHeaders;
        HttpString[] h = new HttpString[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            h[i] = new HttpString(headers[i]);
        }
        this.headers = h;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        if (this.allHeaders) {
            for (HttpString header : this.headers) {
                if (value.getRequestHeaders().contains(header)) continue;
                return false;
            }
            return true;
        }
        for (HttpString header : this.headers) {
            if (!value.getRequestHeaders().contains(header)) continue;
            return true;
        }
        return false;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "hasRequestHeaders";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("headers", String[].class);
            params.put("requireAllHeaders", Boolean.TYPE);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("headers");
        }

        @Override
        public String defaultParameter() {
            return "headers";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] headers = (String[])config.get("headers");
            Boolean all = (Boolean)config.get("requireAllHeaders");
            return new HasRequestHeaderPredicate(headers, all == null ? true : all);
        }
    }
}

