/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.EncodingMapping;
import io.undertow.util.AttachmentKey;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.List;
import org.xnio.conduits.StreamSinkConduit;

public class ContentEncoding
implements ConduitWrapper<StreamSinkConduit> {
    public static final AttachmentKey<ContentEncoding> CONENT_ENCODING = AttachmentKey.create(ContentEncoding.class);
    private final HttpServerExchange exchange;
    private final List<EncodingMapping> encodings;

    public ContentEncoding(HttpServerExchange exchange, List<EncodingMapping> encodings) {
        this.exchange = exchange;
        this.encodings = encodings;
    }

    public String getCurrentContentEncoding() {
        for (EncodingMapping encoding : this.encodings) {
            if (!encoding.getAllowed().resolve(this.exchange)) continue;
            return encoding.getName();
        }
        return Headers.IDENTITY.toString();
    }

    @Override
    public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
        if (exchange.getResponseContentLength() != 0L && exchange.getResponseCode() != 204 && exchange.getResponseCode() != 304) {
            for (EncodingMapping encoding : this.encodings) {
                if (!encoding.getAllowed().resolve(exchange)) continue;
                exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, encoding.getName());
                if (exchange.getRequestMethod().equals(Methods.HEAD)) {
                    return factory.create();
                }
                return encoding.getEncoding().getResponseWrapper().wrap(factory, exchange);
            }
        }
        return factory.create();
    }
}

