/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.api.FragmentedBinaryFrameSender;
import io.undertow.websockets.core.FragmentedMessageChannel;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.impl.DefaultBinaryFrameSender;
import io.undertow.websockets.impl.WebSocketChannelSession;
import java.io.IOException;

final class DefaultFragmentedBinaryFrameSender
extends DefaultBinaryFrameSender
implements FragmentedBinaryFrameSender {
    private FragmentedMessageChannel channel;
    private boolean finalFragment;

    public DefaultFragmentedBinaryFrameSender(WebSocketChannelSession session) {
        super(session);
    }

    @Override
    protected StreamSinkFrameChannel createSink(long payloadSize) throws IOException {
        if (this.session.closeFrameSent) {
            WebSocketMessages.MESSAGES.closeFrameSentBefore();
        }
        if (this.channel == null) {
            this.channel = this.session.getChannel().sendFragmentedBinary();
        }
        StreamSinkFrameChannel sink = this.channel.send(payloadSize, this.finalFragment);
        return sink;
    }

    @Override
    public void finalFragment() {
        this.finalFragment = true;
    }
}

