/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.api.SendCallback;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.impl.StreamSinkChannelUtils;

final class DelegatingSendCallback
implements SendCallback {
    private final SendCallback[] callbacks;

    public DelegatingSendCallback(SendCallback ... callbacks) {
        if (callbacks == null || callbacks.length == 0) {
            throw WebSocketMessages.MESSAGES.senderCallbacksEmpty();
        }
        this.callbacks = callbacks;
    }

    @Override
    public void onCompletion() {
        for (SendCallback callback : this.callbacks) {
            try {
                StreamSinkChannelUtils.safeNotify(callback, null);
            }
            catch (Throwable cause) {
                WebSocketLogger.REQUEST_LOGGER.sendCallbackExecutionError(cause);
            }
        }
    }

    @Override
    public void onError(Throwable error) {
        for (SendCallback callback : this.callbacks) {
            try {
                StreamSinkChannelUtils.safeNotify(callback, error);
            }
            catch (Throwable cause) {
                WebSocketLogger.REQUEST_LOGGER.sendCallbackExecutionError(cause);
            }
        }
    }
}

