/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.provision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.provision.ProvisionException;
import org.jboss.osgi.provision.ProvisionLogger;
import org.jboss.osgi.provision.ProvisionMessages;
import org.jboss.osgi.provision.ProvisionResult;
import org.jboss.osgi.provision.XResourceProvisioner;
import org.jboss.osgi.repository.MavenResourceHandler;
import org.jboss.osgi.repository.XPersistentRepository;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XIdentityRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractEnvironment;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

public abstract class AbstractResourceProvisioner
implements XResourceProvisioner {
    private final XResolver resolver;
    private final XPersistentRepository repository;
    private final String targetType;

    public AbstractResourceProvisioner(XResolver resolver, XPersistentRepository repository, String targetType) {
        this.resolver = resolver;
        this.repository = repository;
        this.targetType = targetType;
    }

    @Override
    public final XResolver getResolver() {
        return this.resolver;
    }

    @Override
    public final XPersistentRepository getRepository() {
        return this.repository;
    }

    @Override
    public List<Object> installResources(List<XResource> resources) throws ProvisionException {
        return this.installResources(resources, Object.class);
    }

    @Override
    public final ProvisionResult findResources(XEnvironment env, Set<XRequirement> reqs) {
        if (env == null) {
            throw ProvisionMessages.MESSAGES.illegalArgumentNull("env");
        }
        if (reqs == null) {
            throw ProvisionMessages.MESSAGES.illegalArgumentNull("reqs");
        }
        ProvisionLogger.LOGGER.debugf("START findResources: %s", reqs);
        ArrayList<XResource> unresolved = new ArrayList<XResource>();
        XEnvironment envclone = this.cloneEnvironment(env);
        for (XRequirement req : reqs) {
            XResource res = req.getResource();
            if (res.getState() == XResource.State.INSTALLED) continue;
            envclone.installResources(new XResource[]{res});
            unresolved.add(res);
        }
        ArrayList<XResource> resources = new ArrayList<XResource>();
        HashSet<XRequirement> unstatisfied = new HashSet<XRequirement>(reqs);
        HashMap<XRequirement, XResource> mapping = new HashMap<XRequirement, XResource>();
        this.findResources(envclone, unresolved, mapping, unstatisfied, resources);
        Iterator itres = resources.iterator();
        while (itres.hasNext()) {
            XResource res = (XResource)itres.next();
            if (!res.isAbstract()) continue;
            itres.remove();
        }
        AbstractProvisionResult result = new AbstractProvisionResult(mapping, unstatisfied, resources);
        ProvisionLogger.LOGGER.debugf("END findResources", new Object[0]);
        ProvisionLogger.LOGGER.debugf("  resources: %s", result.getResources());
        ProvisionLogger.LOGGER.debugf("  unsatisfied: %s", result.getUnsatisfiedRequirements());
        return result;
    }

    private void findResources(XEnvironment env, List<XResource> unresolved, Map<XRequirement, XResource> mapping, Set<XRequirement> unstatisfied, List<XResource> resources) {
        this.resolveInEnvironment(env, unresolved, mapping, unstatisfied, resources);
        if (unstatisfied.isEmpty()) {
            return;
        }
        boolean envModified = false;
        HashSet<XResource> installable = new HashSet<XResource>();
        ProvisionLogger.LOGGER.debugf("Finding unsatisfied reqs", new Object[0]);
        for (XRequirement req : unstatisfied) {
            List mreqs;
            XRequirement mreq;
            XIdentityCapability icap;
            if (!env.findProviders((Requirement)req).isEmpty() || (icap = this.findProviderInRepository(req)) == null) continue;
            String type = (String)icap.getAttribute("type");
            if ("abstract".equals(type) && (mreq = (XRequirement)((mreqs = icap.getResource().getRequirements("maven.identity")).size() == 1 ? (Requirement)mreqs.get(0) : null)) != null) {
                XResource res;
                XCapability mcap = (XCapability)this.repository.findProviders((Requirement)mreq).iterator().next();
                MavenResourceHandler handler = new MavenResourceHandler();
                if ("osgi.bundle".equals(this.targetType)) {
                    res = handler.toBundleResource(mcap.getResource());
                } else {
                    String modspec = (String)mreq.getAttribute("module.identity");
                    if (modspec == null && "module.identity".equals(icap.getNamespace())) {
                        modspec = (String)icap.getAttribute("module.identity");
                    }
                    res = handler.toModuleResource(mcap.getResource(), ModuleIdentifier.fromString((String)modspec));
                }
                icap = res.getIdentityCapability();
            }
            installable.add(icap.getResource());
        }
        String[] namespaces = new String[]{"osgi.identity", "module.identity", "maven.identity"};
        for (XResource res : installable) {
            if (resources.contains(res)) continue;
            Collection<XRequirement> reqs = this.getRequirements(res, namespaces);
            ProvisionLogger.LOGGER.debugf("Adding %d unsatisfied reqs", reqs.size());
            unstatisfied.addAll(reqs);
            env.installResources(new XResource[]{res});
            resources.add(res);
            envModified = true;
        }
        if (envModified) {
            this.findResources(env, unresolved, mapping, unstatisfied, resources);
        }
    }

    private XIdentityCapability findProviderInRepository(XRequirement req) {
        Collection providers = this.repository.findProviders((Requirement)req);
        XIdentityCapability icap = null;
        if (providers.size() == 1) {
            icap = (XIdentityCapability)providers.iterator().next();
            ProvisionLogger.LOGGER.debugf(" Found one: %s", icap);
        } else if (providers.size() > 1) {
            ArrayList<XIdentityCapability> sorted = new ArrayList<XIdentityCapability>();
            for (Capability cap : providers) {
                sorted.add((XIdentityCapability)cap);
            }
            Collections.sort(sorted, new Comparator<XIdentityCapability>(){

                @Override
                public int compare(XIdentityCapability cap1, XIdentityCapability cap2) {
                    Version v1 = cap1.getVersion();
                    Version v2 = cap2.getVersion();
                    return v2.compareTo(v1);
                }
            });
            ProvisionLogger.LOGGER.debugf(" Found multiple: %s", sorted);
            icap = (XIdentityCapability)sorted.get(0);
        } else {
            ProvisionLogger.LOGGER.debugf(" Not found: %s", req);
        }
        return icap;
    }

    private Collection<XRequirement> getRequirements(XResource res, String ... namespaces) {
        HashSet<XRequirement> reqs = new HashSet<XRequirement>();
        if (namespaces != null) {
            for (String ns : namespaces) {
                for (Requirement req : res.getRequirements(ns)) {
                    reqs.add((XRequirement)((XIdentityRequirement)req));
                }
            }
        } else {
            for (Requirement req : res.getRequirements(null)) {
                reqs.add((XRequirement)((XIdentityRequirement)req));
            }
        }
        return reqs;
    }

    private void resolveInEnvironment(XEnvironment env, List<XResource> unresolved, Map<XRequirement, XResource> mapping, Set<XRequirement> unstatisfied, List<XResource> resources) {
        ArrayList<XResource> mandatory = new ArrayList<XResource>();
        mandatory.addAll(unresolved);
        mandatory.addAll(resources);
        try {
            XResolveContext context = this.resolver.createResolveContext(env, mandatory, null);
            Set wiremap = this.resolver.resolve((ResolveContext)context).entrySet();
            for (Map.Entry entry : wiremap) {
                Iterator<XRequirement> itunsat = unstatisfied.iterator();
                while (itunsat.hasNext()) {
                    XRequirement req = itunsat.next();
                    for (Wire wire : (List)entry.getValue()) {
                        if (wire.getRequirement() != req) continue;
                        XResource provider = (XResource)wire.getProvider();
                        mapping.put(req, provider);
                        itunsat.remove();
                    }
                }
            }
        }
        catch (ResolutionException ex) {
            for (Requirement req : ex.getUnresolvedRequirements()) {
                ProvisionLogger.LOGGER.debugf(" unresolved: %s", req);
            }
        }
    }

    private XEnvironment cloneEnvironment(XEnvironment env) {
        if (env instanceof AbstractEnvironment) {
            return ((AbstractEnvironment)env).clone();
        }
        AbstractEnvironment clone = new AbstractEnvironment();
        Iterator itres = env.getResources(null);
        while (itres.hasNext()) {
            clone.installResources(new XResource[]{(XResource)itres.next()});
        }
        return clone;
    }

    static class AbstractProvisionResult
    implements ProvisionResult {
        private final Map<XRequirement, XResource> mapping;
        private final Set<XRequirement> unsatisfied;
        private final List<XResource> resources;

        public AbstractProvisionResult(Map<XRequirement, XResource> mapping, Set<XRequirement> unstatisfied, List<XResource> resources) {
            this.mapping = mapping;
            this.unsatisfied = unstatisfied;
            this.resources = resources;
        }

        @Override
        public Map<XRequirement, XResource> getRequirementMapping() {
            return Collections.unmodifiableMap(this.mapping);
        }

        @Override
        public List<XResource> getResources() {
            return Collections.unmodifiableList(this.resources);
        }

        @Override
        public Set<XRequirement> getUnsatisfiedRequirements() {
            return Collections.unmodifiableSet(this.unsatisfied);
        }
    }
}

