/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities;

import org.hibernate.envers.internal.entities.RelationType;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;

public class RelationDescription {
    private final String fromPropertyName;
    private final RelationType relationType;
    private final String toEntityName;
    private final String mappedByPropertyName;
    private final IdMapper idMapper;
    private final PropertyMapper fakeBidirectionalRelationMapper;
    private final PropertyMapper fakeBidirectionalRelationIndexMapper;
    private final boolean insertable;
    private boolean bidirectional;

    public RelationDescription(String fromPropertyName, RelationType relationType, String toEntityName, String mappedByPropertyName, IdMapper idMapper, PropertyMapper fakeBidirectionalRelationMapper, PropertyMapper fakeBidirectionalRelationIndexMapper, boolean insertable) {
        this.fromPropertyName = fromPropertyName;
        this.relationType = relationType;
        this.toEntityName = toEntityName;
        this.mappedByPropertyName = mappedByPropertyName;
        this.idMapper = idMapper;
        this.fakeBidirectionalRelationMapper = fakeBidirectionalRelationMapper;
        this.fakeBidirectionalRelationIndexMapper = fakeBidirectionalRelationIndexMapper;
        this.insertable = insertable;
        this.bidirectional = false;
    }

    public String getFromPropertyName() {
        return this.fromPropertyName;
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public String getToEntityName() {
        return this.toEntityName;
    }

    public String getMappedByPropertyName() {
        return this.mappedByPropertyName;
    }

    public IdMapper getIdMapper() {
        return this.idMapper;
    }

    public PropertyMapper getFakeBidirectionalRelationMapper() {
        return this.fakeBidirectionalRelationMapper;
    }

    public PropertyMapper getFakeBidirectionalRelationIndexMapper() {
        return this.fakeBidirectionalRelationIndexMapper;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }
}

