/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.jandex.ClassInfo;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="JBAS")
public interface WebLogger
extends BasicLogger {
    public static final WebLogger ROOT_LOGGER = (WebLogger)Logger.getMessageLogger(WebLogger.class, (String)WebLogger.class.getPackage().getName());
    public static final WebLogger WEB_SECURITY_LOGGER = (WebLogger)Logger.getMessageLogger(WebLogger.class, (String)"org.jboss.as.web.security");
    public static final WebLogger WEB_SESSION_LOGGER = (WebLogger)Logger.getMessageLogger(WebLogger.class, (String)"org.jboss.as.web.session");
    public static final WebLogger WEB_SSO_LOGGER = (WebLogger)Logger.getMessageLogger(WebLogger.class, (String)"org.jboss.as.web.sso");
    public static final WebLogger WEB_LOGGER = (WebLogger)Logger.getMessageLogger(WebLogger.class, (String)"org.jboss.web");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18200, value="Failed to start welcome context")
    public void stopWelcomeContextFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18201, value="Failed to destroy welcome context")
    public void destroyWelcomeContextFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18202, value="Error calling onStartup for servlet container initializer: %s")
    public void sciOnStartupError(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18203, value="Error instantiating container component: %s")
    public void componentInstanceCreationFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18204, value="Clustering not supported, falling back to non-clustered session manager")
    public void clusteringNotSupported();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18205, value="Cannot setup overlays for [%s] due to custom resources")
    public void noOverlay(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18206, value="Webapp [%s] is unavailable due to startup errors")
    public void unavailable(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18208, value="Failed to start context")
    public void stopContextFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18209, value="Failed to destroy context")
    public void destroyContextFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18210, value="Register web context: %s")
    public void registerWebapp(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18214, value="Error during login/password authenticate")
    public void authenticateError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18215, value="Error during certificate authenticate")
    public void authenticateErrorCert(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18216, value="Error during digest authenticate")
    public void authenticateErrorDigest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18217, value="Error obtaining authorization helper")
    public void noAuthorizationHelper(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18218, value="Exception in obtaining server authentication manager")
    public void noServerAuthenticationManager(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18219, value="JASPI validation for unprotected request context %s failed")
    public void failJASPIValidation(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18220, value="Caught Exception: %s")
    public void unsupportedEncoding(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18221, value="Error forwarding to login page: %s")
    public void errorForwardingToLoginPage(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18222, value="Error forwarding to error page: %s")
    public void errorForwardingToErrorPage(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18224, value="Unregister web context: %s")
    public void unregisterWebapp(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18225, value="Failed to purge EL cache.")
    public void couldNotPurgeELCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18226, value="Skipped SCI for jar: %s.")
    public void skippedSCI(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18227, value="Could not load class designated by HandlesTypes [%s].")
    public void cannotLoadDesignatedHandleTypes(ClassInfo var1, @Cause Exception var2);
}

