/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.Util;

public class TransientCacheEntry
extends AbstractInternalCacheEntry {
    protected TransientCacheValue cacheValue;

    protected TransientCacheEntry(Object key, TransientCacheValue value) {
        super(key);
        this.cacheValue = value;
    }

    public TransientCacheEntry(Object key, Object value, long maxIdle, long lastUsed) {
        super(key);
        this.cacheValue = new TransientCacheValue(value, maxIdle, lastUsed);
    }

    @Override
    public Object getValue() {
        return this.cacheValue.value;
    }

    @Override
    public Object setValue(Object value) {
        return this.cacheValue.setValue(value);
    }

    @Override
    public final void touch() {
        this.touch(System.currentTimeMillis());
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.cacheValue.lastUsed = currentTimeMillis;
    }

    @Override
    public final void reincarnate() {
    }

    @Override
    public void reincarnate(long now) {
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean isExpired(long now) {
        return this.cacheValue.isExpired(now);
    }

    @Override
    public boolean isExpired() {
        return this.cacheValue.isExpired();
    }

    public void setMaxIdle(long maxIdle) {
        this.cacheValue.maxIdle = maxIdle;
    }

    @Override
    public long getCreated() {
        return -1L;
    }

    @Override
    public final long getLastUsed() {
        return this.cacheValue.lastUsed;
    }

    @Override
    public long getLifespan() {
        return -1L;
    }

    @Override
    public long getExpiryTime() {
        return this.cacheValue.maxIdle > -1L ? this.cacheValue.lastUsed + this.cacheValue.maxIdle : -1L;
    }

    @Override
    public final long getMaxIdle() {
        return this.cacheValue.maxIdle;
    }

    @Override
    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    @Override
    public Metadata getMetadata() {
        return new EmbeddedMetadata.Builder().maxIdle(this.cacheValue.getMaxIdle(), TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        throw new IllegalStateException("Metadata cannot be set on mortal entries. They need to be recreated via the entry factory.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransientCacheEntry that = (TransientCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.cacheValue.value != null ? !this.cacheValue.value.equals(that.cacheValue.value) : that.cacheValue.value != null) {
            return false;
        }
        if (this.cacheValue.lastUsed != that.cacheValue.lastUsed) {
            return false;
        }
        return this.cacheValue.maxIdle == that.cacheValue.maxIdle;
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.cacheValue.value != null ? this.cacheValue.value.hashCode() : 0);
        result = 31 * result + (int)(this.cacheValue.lastUsed ^ this.cacheValue.lastUsed >>> 32);
        result = 31 * result + (int)(this.cacheValue.maxIdle ^ this.cacheValue.maxIdle >>> 32);
        return result;
    }

    @Override
    public TransientCacheEntry clone() {
        TransientCacheEntry clone = (TransientCacheEntry)super.clone();
        clone.cacheValue = this.cacheValue.clone();
        return clone;
    }

    @Override
    public String toString() {
        return "TransientCacheEntry{key=" + this.key + ", value=" + this.cacheValue + "}";
    }

    public static class Externalizer
    extends AbstractExternalizer<TransientCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, TransientCacheEntry tce) throws IOException {
            output.writeObject(tce.key);
            output.writeObject(tce.cacheValue.value);
            UnsignedNumeric.writeUnsignedLong(output, tce.cacheValue.lastUsed);
            output.writeLong(tce.cacheValue.maxIdle);
        }

        @Override
        public TransientCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new TransientCacheEntry(k, v, maxIdle, lastUsed);
        }

        @Override
        public Integer getId() {
            return 12;
        }

        @Override
        public Set<Class<? extends TransientCacheEntry>> getTypeClasses() {
            return Util.asSet(TransientCacheEntry.class);
        }
    }
}

