/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.Util;

public class TransientMortalCacheEntry
extends AbstractInternalCacheEntry {
    protected TransientMortalCacheValue cacheValue;

    public TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan, long currentTimeMillis) {
        super(key);
        this.cacheValue = new TransientMortalCacheValue(value, currentTimeMillis, lifespan, maxIdle);
        this.touch(currentTimeMillis);
    }

    protected TransientMortalCacheEntry(Object key, TransientMortalCacheValue value) {
        super(key);
        this.cacheValue = value;
    }

    public TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan, long lastUsed, long created) {
        super(key);
        this.cacheValue = new TransientMortalCacheValue(value, created, lifespan, maxIdle, lastUsed);
    }

    public void setLifespan(long lifespan) {
        this.cacheValue.lifespan = lifespan;
    }

    public void setMaxIdle(long maxIdle) {
        this.cacheValue.maxIdle = maxIdle;
    }

    @Override
    public Object getValue() {
        return this.cacheValue.value;
    }

    @Override
    public long getLifespan() {
        return this.cacheValue.lifespan;
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public long getCreated() {
        return this.cacheValue.created;
    }

    @Override
    public boolean isExpired(long now) {
        return this.cacheValue.isExpired(now);
    }

    @Override
    public boolean isExpired() {
        return this.cacheValue.isExpired();
    }

    @Override
    public final long getExpiryTime() {
        long muet;
        long lset = this.cacheValue.lifespan > -1L ? this.cacheValue.created + this.cacheValue.lifespan : -1L;
        long l = muet = this.cacheValue.maxIdle > -1L ? this.cacheValue.lastUsed + this.cacheValue.maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    @Override
    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    @Override
    public long getLastUsed() {
        return this.cacheValue.lastUsed;
    }

    @Override
    public final void touch() {
        this.touch(System.currentTimeMillis());
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.cacheValue.lastUsed = currentTimeMillis;
    }

    @Override
    public final void reincarnate() {
        this.reincarnate(System.currentTimeMillis());
    }

    @Override
    public void reincarnate(long now) {
        this.cacheValue.created = now;
    }

    @Override
    public long getMaxIdle() {
        return this.cacheValue.maxIdle;
    }

    @Override
    public Object setValue(Object value) {
        return this.cacheValue.setValue(value);
    }

    @Override
    public Metadata getMetadata() {
        return new EmbeddedMetadata.Builder().lifespan(this.cacheValue.getLifespan()).maxIdle(this.cacheValue.getMaxIdle()).build();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        throw new IllegalStateException("Metadata cannot be set on mortal entries. They need to be recreated via the entry factory.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransientMortalCacheEntry that = (TransientMortalCacheEntry)o;
        if (this.cacheValue.created != that.cacheValue.created) {
            return false;
        }
        return this.cacheValue.lifespan == that.cacheValue.lifespan;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.cacheValue.created ^ this.cacheValue.created >>> 32);
        result = 31 * result + (int)(this.cacheValue.lifespan ^ this.cacheValue.lifespan >>> 32);
        return result;
    }

    @Override
    public TransientMortalCacheEntry clone() {
        TransientMortalCacheEntry clone = (TransientMortalCacheEntry)super.clone();
        clone.cacheValue = this.cacheValue.clone();
        return clone;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "key=" + this.key + ", value=" + this.cacheValue + "}";
    }

    public static class Externalizer
    extends AbstractExternalizer<TransientMortalCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, TransientMortalCacheEntry entry) throws IOException {
            output.writeObject(entry.key);
            output.writeObject(entry.cacheValue.value);
            UnsignedNumeric.writeUnsignedLong(output, entry.cacheValue.created);
            output.writeLong(entry.cacheValue.lifespan);
            UnsignedNumeric.writeUnsignedLong(output, entry.cacheValue.lastUsed);
            output.writeLong(entry.cacheValue.maxIdle);
        }

        @Override
        public TransientMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new TransientMortalCacheEntry(k, v, maxIdle, lifespan, lastUsed, created);
        }

        @Override
        public Integer getId() {
            return 13;
        }

        @Override
        public Set<Class<? extends TransientMortalCacheEntry>> getTypeClasses() {
            return Util.asSet(TransientMortalCacheEntry.class);
        }
    }
}

