/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.Util;

public class MetadataMortalCacheEntry
extends AbstractInternalCacheEntry
implements MetadataAware {
    protected MetadataMortalCacheValue cacheValue;

    public MetadataMortalCacheEntry(Object key, Object value, Metadata metadata, long created) {
        super(key);
        this.cacheValue = new MetadataMortalCacheValue(value, metadata, created);
    }

    MetadataMortalCacheEntry(Object key, MetadataMortalCacheValue cacheValue) {
        super(key);
        this.cacheValue = cacheValue;
    }

    @Override
    public Object getValue() {
        return this.cacheValue.value;
    }

    @Override
    public Object setValue(Object value) {
        return this.cacheValue.setValue(value);
    }

    @Override
    public final boolean isExpired(long now) {
        return ExpiryHelper.isExpiredMortal(this.cacheValue.metadata.lifespan(), this.cacheValue.created, now);
    }

    @Override
    public final boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public final long getCreated() {
        return this.cacheValue.created;
    }

    @Override
    public final long getLastUsed() {
        return -1L;
    }

    @Override
    public final long getLifespan() {
        return this.cacheValue.metadata.lifespan();
    }

    @Override
    public final long getMaxIdle() {
        return -1L;
    }

    @Override
    public final long getExpiryTime() {
        long lifespan = this.cacheValue.metadata.lifespan();
        return lifespan > -1L ? this.cacheValue.created + lifespan : -1L;
    }

    @Override
    public final void touch() {
    }

    @Override
    public final void touch(long currentTimeMillis) {
    }

    @Override
    public final void reincarnate() {
        this.reincarnate(System.currentTimeMillis());
    }

    @Override
    public void reincarnate(long now) {
        this.cacheValue.setCreated(now);
    }

    @Override
    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    @Override
    public Metadata getMetadata() {
        return this.cacheValue.getMetadata();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.cacheValue.setMetadata(metadata);
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataMortalCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, MetadataMortalCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(ice.cacheValue.value);
            output.writeObject(ice.cacheValue.getMetadata());
            UnsignedNumeric.writeUnsignedLong(output, ice.cacheValue.getCreated());
        }

        @Override
        public MetadataMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            return new MetadataMortalCacheEntry(k, v, metadata, created);
        }

        @Override
        public Integer getId() {
            return 77;
        }

        @Override
        public Set<Class<? extends MetadataMortalCacheEntry>> getTypeClasses() {
            return Util.asSet(MetadataMortalCacheEntry.class);
        }
    }
}

