/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataTransientCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.Util;

public class MetadataTransientCacheEntry
extends AbstractInternalCacheEntry
implements MetadataAware {
    protected MetadataTransientCacheValue cacheValue;

    public MetadataTransientCacheEntry(Object key, MetadataTransientCacheValue value) {
        super(key);
        this.cacheValue = value;
    }

    public MetadataTransientCacheEntry(Object key, Object value, Metadata metadata, long lastUsed) {
        super(key);
        this.cacheValue = new MetadataTransientCacheValue(value, metadata, lastUsed);
    }

    @Override
    public Object getValue() {
        return this.cacheValue.value;
    }

    @Override
    public Object setValue(Object value) {
        return this.cacheValue.setValue(value);
    }

    @Override
    public final void touch() {
        this.touch(System.currentTimeMillis());
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.cacheValue.lastUsed = currentTimeMillis;
    }

    @Override
    public final void reincarnate() {
    }

    @Override
    public void reincarnate(long now) {
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public boolean isExpired(long now) {
        return this.cacheValue.isExpired(now);
    }

    @Override
    public boolean isExpired() {
        return this.cacheValue.isExpired();
    }

    @Override
    public long getCreated() {
        return -1L;
    }

    @Override
    public final long getLastUsed() {
        return this.cacheValue.lastUsed;
    }

    @Override
    public long getLifespan() {
        return -1L;
    }

    @Override
    public long getExpiryTime() {
        long maxIdle = this.cacheValue.metadata.maxIdle();
        return maxIdle > -1L ? this.cacheValue.lastUsed + maxIdle : -1L;
    }

    @Override
    public final long getMaxIdle() {
        return this.cacheValue.metadata.maxIdle();
    }

    @Override
    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    @Override
    public Metadata getMetadata() {
        return this.cacheValue.getMetadata();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.cacheValue.setMetadata(metadata);
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataTransientCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, MetadataTransientCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(ice.cacheValue.value);
            output.writeObject(ice.cacheValue.getMetadata());
            UnsignedNumeric.writeUnsignedLong(output, ice.cacheValue.getLastUsed());
        }

        @Override
        public MetadataTransientCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            return new MetadataTransientCacheEntry(k, v, metadata, lastUsed);
        }

        @Override
        public Integer getId() {
            return 78;
        }

        @Override
        public Set<Class<? extends MetadataTransientCacheEntry>> getTypeClasses() {
            return Util.asSet(MetadataTransientCacheEntry.class);
        }
    }
}

