/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.Util;

public class MetadataTransientMortalCacheEntry
extends AbstractInternalCacheEntry
implements MetadataAware {
    protected MetadataTransientMortalCacheValue cacheValue;

    public MetadataTransientMortalCacheEntry(Object key, Object value, Metadata metadata, long now) {
        this(key, value, metadata, now, now);
    }

    public MetadataTransientMortalCacheEntry(Object key, Object value, Metadata metadata, long lastUsed, long created) {
        super(key);
        this.cacheValue = new MetadataTransientMortalCacheValue(value, metadata, created, lastUsed);
    }

    MetadataTransientMortalCacheEntry(Object key, MetadataTransientMortalCacheValue cacheValue) {
        super(key);
        this.cacheValue = cacheValue;
    }

    @Override
    public Object getValue() {
        return this.cacheValue.value;
    }

    @Override
    public long getLifespan() {
        return this.cacheValue.metadata.lifespan();
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public long getCreated() {
        return this.cacheValue.created;
    }

    @Override
    public boolean isExpired(long now) {
        return this.cacheValue.isExpired(now);
    }

    @Override
    public boolean isExpired() {
        return this.cacheValue.isExpired();
    }

    @Override
    public final long getExpiryTime() {
        long muet;
        long lifespan = this.cacheValue.metadata.lifespan();
        long lset = lifespan > -1L ? this.cacheValue.created + lifespan : -1L;
        long maxIdle = this.cacheValue.metadata.maxIdle();
        long l = muet = maxIdle > -1L ? this.cacheValue.lastUsed + maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    @Override
    public InternalCacheValue toInternalCacheValue() {
        return this.cacheValue;
    }

    @Override
    public long getLastUsed() {
        return this.cacheValue.lastUsed;
    }

    @Override
    public final void touch() {
        this.cacheValue.lastUsed = System.currentTimeMillis();
    }

    @Override
    public final void touch(long currentTimeMillis) {
        this.cacheValue.lastUsed = currentTimeMillis;
    }

    @Override
    public final void reincarnate() {
        this.reincarnate(System.currentTimeMillis());
    }

    @Override
    public void reincarnate(long now) {
        this.cacheValue.created = now;
    }

    @Override
    public long getMaxIdle() {
        return this.cacheValue.metadata.maxIdle();
    }

    @Override
    public Object setValue(Object value) {
        return this.cacheValue.setValue(value);
    }

    @Override
    public Metadata getMetadata() {
        return this.cacheValue.getMetadata();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.cacheValue.setMetadata(metadata);
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataTransientMortalCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, MetadataTransientMortalCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(ice.cacheValue.value);
            output.writeObject(ice.cacheValue.metadata);
            UnsignedNumeric.writeUnsignedLong(output, ice.cacheValue.getCreated());
            UnsignedNumeric.writeUnsignedLong(output, ice.cacheValue.getLastUsed());
        }

        @Override
        public MetadataTransientMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            return new MetadataTransientMortalCacheEntry(k, v, metadata, lastUsed, created);
        }

        @Override
        public Integer getId() {
            return 79;
        }

        @Override
        public Set<Class<? extends MetadataTransientMortalCacheEntry>> getTypeClasses() {
            return Util.asSet(MetadataTransientMortalCacheEntry.class);
        }
    }
}

