/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Equivalence;

public abstract class AbstractInvocationContextContainer
implements InvocationContextContainer {
    protected final ThreadLocal<InvocationContext> ctxHolder = new ThreadLocal();
    protected Configuration config;
    protected Equivalence keyEq;

    public void init(Configuration config) {
        this.config = config;
    }

    public void start() {
        this.keyEq = this.config.dataContainer().keyEquivalence();
    }

    @Override
    public InvocationContext createRemoteInvocationContextForCommand(VisitableCommand cacheCommand, Address origin) {
        if (cacheCommand instanceof FlagAffectedCommand) {
            InvocationContext context = this.createRemoteInvocationContext(origin);
            this.ctxHolder.set(context);
            return context;
        }
        return this.createRemoteInvocationContext(origin);
    }

    @Override
    public InvocationContext getInvocationContext(boolean quiet) {
        InvocationContext ctx = this.ctxHolder.get();
        if (ctx == null && !quiet) {
            throw new IllegalStateException("No InvocationContext associated with current thread!");
        }
        return ctx;
    }

    @Override
    public void clearThreadLocal() {
        this.ctxHolder.remove();
    }
}

