/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CancellationService;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.distexec.DistributedExecutionCompletionService;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distexec.DistributedTask;
import org.infinispan.distexec.DistributedTaskBuilder;
import org.infinispan.distexec.DistributedTaskExecutionPolicy;
import org.infinispan.distexec.DistributedTaskFailoverPolicy;
import org.infinispan.distexec.FailoverContext;
import org.infinispan.distexec.spi.DistributedTaskLifecycleService;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.TimeService;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultExecutorService
extends AbstractExecutorService
implements DistributedExecutorService {
    private static final NodeFilter SAME_MACHINE_FILTER = new NodeFilter(){

        @Override
        public boolean include(TopologyAwareAddress thisAddress, TopologyAwareAddress otherAddress) {
            return thisAddress.isSameMachine(otherAddress);
        }
    };
    private static final NodeFilter SAME_RACK_FILTER = new NodeFilter(){

        @Override
        public boolean include(TopologyAwareAddress thisAddress, TopologyAwareAddress otherAddress) {
            return thisAddress.isSameRack(otherAddress);
        }
    };
    private static final NodeFilter SAME_SITE_FILTER = new NodeFilter(){

        @Override
        public boolean include(TopologyAwareAddress thisAddress, TopologyAwareAddress otherAddress) {
            return thisAddress.isSameSite(otherAddress);
        }
    };
    private static final NodeFilter ALL_FILTER = new NodeFilter(){

        @Override
        public boolean include(TopologyAwareAddress thisAddress, TopologyAwareAddress otherAddress) {
            return true;
        }
    };
    public static final Address LOCAL_MODE_ADDRESS = new Address(){

        @Override
        public int compareTo(Address o) {
            return 0;
        }
    };
    public static final DistributedTaskFailoverPolicy NO_FAILOVER = new NoTaskFailoverPolicy();
    public static final DistributedTaskFailoverPolicy RANDOM_NODE_FAILOVER = new RandomNodeTaskFailoverPolicy();
    private static final Log log = LogFactory.getLog(DefaultExecutorService.class);
    private static final boolean trace = log.isTraceEnabled();
    protected final AtomicBoolean isShutdown = new AtomicBoolean(false);
    protected final AdvancedCache cache;
    protected final RpcManager rpc;
    protected final InterceptorChain invoker;
    protected final CommandsFactory factory;
    protected final Marshaller marshaller;
    protected final ExecutorService localExecutorService;
    protected final CancellationService cancellationService;
    protected final boolean takeExecutorOwnership;
    private final TimeService timeService;

    public DefaultExecutorService(Cache<?, ?> masterCacheNode) {
        this(masterCacheNode, Executors.newSingleThreadExecutor(), true);
    }

    public DefaultExecutorService(Cache<?, ?> masterCacheNode, ExecutorService localExecutorService) {
        this(masterCacheNode, localExecutorService, false);
    }

    public DefaultExecutorService(Cache<?, ?> masterCacheNode, ExecutorService localExecutorService, boolean takeExecutorOwnership) {
        if (masterCacheNode == null) {
            throw new IllegalArgumentException("Can not use null cache for DefaultExecutorService");
        }
        if (localExecutorService == null) {
            throw new IllegalArgumentException("Can not use null instance of ExecutorService");
        }
        if (localExecutorService.isShutdown()) {
            throw new IllegalArgumentException("Can not use an instance of ExecutorService which is shutdown");
        }
        this.ensureProperCacheState(masterCacheNode.getAdvancedCache());
        this.cache = masterCacheNode.getAdvancedCache();
        ComponentRegistry registry = this.cache.getComponentRegistry();
        this.rpc = this.cache.getRpcManager();
        this.invoker = registry.getComponent(InterceptorChain.class);
        this.factory = registry.getComponent(CommandsFactory.class);
        this.marshaller = registry.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        this.cancellationService = registry.getComponent(CancellationService.class);
        this.localExecutorService = localExecutorService;
        this.takeExecutorOwnership = takeExecutorOwnership;
        this.timeService = registry.getTimeService();
    }

    @Override
    public <T> DistributedTaskBuilder<T> createDistributedTaskBuilder(Callable<T> callable) {
        long to = this.cache.getCacheConfiguration().clustering().sync().replTimeout();
        DefaultDistributedTaskBuilder<T> dtb = new DefaultDistributedTaskBuilder<T>(to);
        dtb.callable(callable);
        return dtb;
    }

    public <T> NotifyingFuture<T> submit(Runnable task, T result) {
        return (NotifyingFuture)super.submit(task, result);
    }

    public <T> NotifyingFuture<T> submit(Callable<T> task) {
        return (NotifyingFuture)super.submit(task);
    }

    @Override
    public void shutdown() {
        this.realShutdown(false);
    }

    protected List<Address> getMembers() {
        if (this.rpc != null) {
            return this.rpc.getMembers();
        }
        return Collections.singletonList(this.getAddress());
    }

    protected <T> List<Address> executionCandidates(DistributedTask<T> task) {
        return this.filterMembers(task.getTaskExecutionPolicy(), this.getMembers());
    }

    private Address getAddress() {
        if (this.rpc != null) {
            return this.rpc.getAddress();
        }
        return LOCAL_MODE_ADDRESS;
    }

    private List<Runnable> realShutdown(boolean interrupt) {
        this.isShutdown.set(true);
        if (this.takeExecutorOwnership) {
            if (interrupt) {
                this.localExecutorService.shutdownNow();
            } else {
                this.localExecutorService.shutdown();
            }
        }
        return InfinispanCollections.emptyList();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.realShutdown(true);
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown.get();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    private <T> T doInvokeAny(Collection<? extends Callable<T>> tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException ee;
        ArrayList<Future<T>> futures;
        block18: {
            if (tasks == null) {
                throw new NullPointerException();
            }
            int ntasks = tasks.size();
            if (ntasks == 0) {
                throw new IllegalArgumentException();
            }
            futures = new ArrayList<Future<T>>(ntasks);
            DistributedExecutionCompletionService<T> ecs = new DistributedExecutionCompletionService<T>(this);
            ee = null;
            long lastTime = timed ? this.timeService.time() : 0L;
            Iterator<Callable<T>> it = tasks.iterator();
            futures.add(ecs.submit(it.next()));
            --ntasks;
            int active = 1;
            while (true) {
                Object now22;
                Future f;
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit(it.next()));
                        ++active;
                    } else {
                        if (active == 0) break;
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            long now22 = this.timeService.time();
                            nanos -= this.timeService.timeDuration(lastTime, now22, TimeUnit.NANOSECONDS);
                            lastTime = now22;
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    now22 = f.get();
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (ExecutionException eex) {
                    ee = eex;
                    continue;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                return (T)now22;
                break;
            }
            if (ee != null) break block18;
            ee = new ExecutionException(){
                private static final long serialVersionUID = 200818694545553992L;
            };
        }
        throw ee;
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Runnable command) {
        DistributedTaskPart cmd;
        if (this.isShutdown.get()) throw new RejectedExecutionException();
        if (command instanceof DistributedTaskPart) {
            cmd = (DistributedTaskPart)command;
        } else {
            if (!(command instanceof Serializable)) throw new IllegalArgumentException("Runnable command is not Serializable  " + command);
            cmd = (DistributedTaskPart)this.newTaskFor(command, null);
        }
        cmd.execute();
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableAdapter<T> adapter = new RunnableAdapter<T>(runnable, value);
        return this.newTaskFor(adapter);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        DistributedTaskBuilder<T> distributedTaskBuilder = this.createDistributedTaskBuilder(callable);
        DistributedTask<T> task = distributedTaskBuilder.build();
        DistributedExecuteCommand<T> executeCommand = this.factory.buildDistributedExecuteCommand(callable, this.getAddress(), null);
        return this.createDistributedTaskPart(task, executeCommand, this.selectExecutionNode(task), 0);
    }

    @Override
    public <T> Future<T> submit(Address target, Callable<T> task) {
        DistributedTaskBuilder<T> distributedTaskBuilder = this.createDistributedTaskBuilder(task);
        DistributedTask<T> distributedTask = distributedTaskBuilder.build();
        return this.submit(target, distributedTask);
    }

    @Override
    public <T> Future<T> submit(Address target, DistributedTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        List<Address> members = this.getMembers();
        if (!members.contains(target)) {
            throw new IllegalArgumentException("Target node " + target + " is not a cluster member, members are " + members);
        }
        Address me = this.getAddress();
        DistributedExecuteCommand<T> c = null;
        c = target.equals(me) ? this.factory.buildDistributedExecuteCommand(this.clone(task.getCallable()), me, null) : this.factory.buildDistributedExecuteCommand(task.getCallable(), me, null);
        DistributedTaskPart<T> part = this.createDistributedTaskPart(task, c, target, 0);
        part.execute();
        return part;
    }

    @Override
    public <T, K> Future<T> submit(Callable<T> task, K ... input) {
        DistributedTaskBuilder<T> distributedTaskBuilder = this.createDistributedTaskBuilder(task);
        DistributedTask<T> distributedTask = distributedTaskBuilder.build();
        return this.submit(distributedTask, input);
    }

    @Override
    public <T, K> Future<T> submit(DistributedTask<T> task, K ... input) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.inputKeysSpecified(input)) {
            Map<Address, List<K>> nodesKeysMap = this.keysToExecutionNodes(task.getTaskExecutionPolicy(), input);
            this.checkExecutionPolicy(task, nodesKeysMap, input);
            Address me = this.getAddress();
            DistributedExecuteCommand<T> c = this.factory.buildDistributedExecuteCommand(task.getCallable(), me, Arrays.asList(input));
            ArrayList<Address> nodes = new ArrayList<Address>(nodesKeysMap.keySet());
            DistributedTaskPart<T> part = this.createDistributedTaskPart(task, c, Arrays.asList(input), this.selectExecutionNode(nodes), 0);
            part.execute();
            return part;
        }
        return this.submit((Callable)task.getCallable());
    }

    @Override
    public <T> List<Future<T>> submitEverywhere(Callable<T> task) {
        DistributedTaskBuilder<T> distributedTaskBuilder = this.createDistributedTaskBuilder(task);
        DistributedTask<T> distributedTask = distributedTaskBuilder.build();
        return this.submitEverywhere(distributedTask);
    }

    @Override
    public <T> List<Future<T>> submitEverywhere(DistributedTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        List<Address> members = this.executionCandidates(task);
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(members.size());
        Address me = this.getAddress();
        for (Address target : members) {
            DistributedExecuteCommand<T> c = null;
            c = target.equals(me) ? this.factory.buildDistributedExecuteCommand(this.clone(task.getCallable()), me, null) : this.factory.buildDistributedExecuteCommand(task.getCallable(), me, null);
            DistributedTaskPart<T> part = this.createDistributedTaskPart(task, c, target, 0);
            futures.add(part);
            part.execute();
        }
        return futures;
    }

    @Override
    public <T, K> List<Future<T>> submitEverywhere(Callable<T> task, K ... input) {
        DistributedTaskBuilder<T> distributedTaskBuilder = this.createDistributedTaskBuilder(task);
        DistributedTask<T> distributedTask = distributedTaskBuilder.build();
        return this.submitEverywhere(distributedTask, input);
    }

    @Override
    public <T, K> List<Future<T>> submitEverywhere(DistributedTask<T> task, K ... input) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.inputKeysSpecified(input)) {
            ArrayList<Future<T>> futures = new ArrayList<Future<T>>(input.length * 2);
            Address me = this.getAddress();
            Map<Address, List<K>> nodesKeysMap = this.keysToExecutionNodes(task.getTaskExecutionPolicy(), input);
            this.checkExecutionPolicy(task, nodesKeysMap, input);
            for (Map.Entry<Address, List<K>> e : nodesKeysMap.entrySet()) {
                Address target = e.getKey();
                DistributedExecuteCommand<T> c = null;
                c = target.equals(me) ? this.factory.buildDistributedExecuteCommand(this.clone(task.getCallable()), me, e.getValue()) : this.factory.buildDistributedExecuteCommand(task.getCallable(), me, e.getValue());
                DistributedTaskPart<T> part = this.createDistributedTaskPart(task, c, e.getValue(), target, 0);
                futures.add(part);
                part.execute();
            }
            return futures;
        }
        return this.submitEverywhere(task);
    }

    protected <T> Callable<T> clone(Callable<T> task) {
        return Util.cloneWithMarshaller(this.marshaller, task);
    }

    protected <T, K> DistributedTaskPart<T> createDistributedTaskPart(DistributedTask<T> task, DistributedExecuteCommand<T> c, List<K> inputKeys, Address target, int failoverCount) {
        return new DistributedTaskPart<T>(task, c, inputKeys, target, failoverCount);
    }

    protected <T, K> DistributedTaskPart<T> createDistributedTaskPart(DistributedTask<T> task, DistributedExecuteCommand<T> c, Address target, int failoverCount) {
        return this.createDistributedTaskPart(task, c, Collections.emptyList(), target, failoverCount);
    }

    private <T, K> void checkExecutionPolicy(DistributedTask<T> task, Map<Address, List<K>> nodesKeysMap, K ... input) {
        if (nodesKeysMap == null || nodesKeysMap.isEmpty()) {
            throw new IllegalStateException("DistributedTaskExecutionPolicy " + (Object)((Object)task.getTaskExecutionPolicy()) + " for task " + task + " returned invalid keysToExecutionNodes " + nodesKeysMap + " execution policy plan for a given input " + Arrays.toString(input));
        }
    }

    private <K> boolean inputKeysSpecified(K ... input) {
        return input != null && input.length > 0;
    }

    protected Address selectExecutionNode(List<Address> candidates) {
        List<Address> list = this.randomClusterMembers(candidates, 1);
        return list.get(0);
    }

    protected <T> Address selectExecutionNode(DistributedTask<T> task) {
        return this.selectExecutionNode(this.executionCandidates(task));
    }

    protected List<Address> randomClusterMembers(List<Address> members, int numNeeded) {
        if (members == null || members.isEmpty()) {
            throw new IllegalArgumentException("Invalid member list " + members);
        }
        if (members.size() < numNeeded) {
            log.cannotSelectRandomMembers(numNeeded, members);
            numNeeded = members.size();
        }
        ArrayList<Address> membersCopy = new ArrayList<Address>(members);
        ArrayList<Address> chosen = new ArrayList<Address>(numNeeded);
        Random r = new Random();
        while (!membersCopy.isEmpty() && numNeeded >= chosen.size()) {
            int count = membersCopy.size();
            Address address = (Address)membersCopy.remove(r.nextInt(count));
            chosen.add(address);
        }
        return chosen;
    }

    protected <K> Map<Address, List<K>> keysToExecutionNodes(DistributedTaskExecutionPolicy policy, K ... input) {
        DistributionManager dm = this.cache.getDistributionManager();
        HashMap<Address, List<Address>> addressToKey = new HashMap<Address, List<Address>>(input.length * 2);
        boolean usingREPLMode = dm == null;
        for (K key : input) {
            Address ownerOfKey = null;
            if (usingREPLMode) {
                List<Address> members = new ArrayList<Address>(this.getMembers());
                members = this.filterMembers(policy, members);
                Collections.shuffle(members);
                ownerOfKey = members.get(0);
            } else {
                List<Address> owners = dm.locate(key);
                List<Address> filtered = this.filterMembers(policy, owners);
                ownerOfKey = !filtered.isEmpty() ? filtered.get(0) : owners.get(0);
            }
            LinkedList<K> keysAtNode = (LinkedList<K>)addressToKey.get(ownerOfKey);
            if (keysAtNode == null) {
                keysAtNode = new LinkedList<K>();
                addressToKey.put(ownerOfKey, keysAtNode);
            }
            keysAtNode.add(key);
        }
        return addressToKey;
    }

    private List<Address> filterMembers(DistributedTaskExecutionPolicy policy, List<Address> members) {
        NodeFilter filter = null;
        switch (policy) {
            case SAME_MACHINE: {
                filter = SAME_MACHINE_FILTER;
                break;
            }
            case SAME_SITE: {
                filter = SAME_SITE_FILTER;
                break;
            }
            case SAME_RACK: {
                filter = SAME_RACK_FILTER;
                break;
            }
            case ALL: {
                filter = ALL_FILTER;
                break;
            }
            default: {
                filter = ALL_FILTER;
            }
        }
        ArrayList<Address> result = new ArrayList<Address>();
        for (Address address : members) {
            if (address instanceof TopologyAwareAddress) {
                TopologyAwareAddress taa = (TopologyAwareAddress)address;
                if (!filter.include(taa, (TopologyAwareAddress)this.getAddress())) continue;
                result.add(address);
                continue;
            }
            result.add(address);
        }
        return result;
    }

    private void ensureProperCacheState(AdvancedCache<?, ?> cache) throws NullPointerException, IllegalStateException {
        if (cache.getStatus() != ComponentStatus.RUNNING) {
            throw new IllegalStateException("Invalid cache state " + (Object)((Object)cache.getStatus()));
        }
    }

    private static final class RunnableAdapter<T>
    implements Callable<T>,
    Serializable {
        private static final long serialVersionUID = 6629286923873531028L;
        protected Runnable task;
        protected T result;

        protected RunnableAdapter() {
        }

        protected RunnableAdapter(Runnable task, T result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public T call() {
            this.task.run();
            return this.result;
        }
    }

    private class DistributedTaskPart<V>
    implements NotifyingNotifiableFuture<V>,
    RunnableFuture<V> {
        private final DistributedExecuteCommand<V> distCommand;
        private volatile Future<V> f;
        private volatile boolean callCompleted = false;
        private final Set<FutureListener<V>> listeners = new CopyOnWriteArraySet<FutureListener<V>>();
        private final ReadWriteLock listenerLock = new ReentrantReadWriteLock();
        private final Address executionTarget;
        private final List<Object> inputKeys;
        private final DistributedTask<V> owningTask;
        private int failedOverCount;
        private volatile boolean done;
        private volatile boolean cancelled;

        public DistributedTaskPart(DistributedTask<V> task, DistributedExecuteCommand<V> command, List<Object> inputKeys, Address executionTarget, int failoverCount) {
            this.owningTask = task;
            this.distCommand = command;
            this.inputKeys = inputKeys;
            this.executionTarget = executionTarget;
            this.failedOverCount = failoverCount;
        }

        public List<Object> getInputKeys() {
            return this.inputKeys;
        }

        public DistributedExecuteCommand<V> getCommand() {
            return this.distCommand;
        }

        public DistributedTask<V> getOwningTask() {
            return this.owningTask;
        }

        public Address getExecutionTarget() {
            return this.executionTarget;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        public boolean isLocalNodeExecutionTarget() {
            return DefaultExecutorService.this.getAddress().equals(this.getExecutionTarget());
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.isCancelled()) {
                CancelCommand ccc = DefaultExecutorService.this.factory.buildCancelCommandCommand(this.distCommand.getUUID());
                if (this.isLocalNodeExecutionTarget()) {
                    ccc.init(DefaultExecutorService.this.cancellationService);
                    try {
                        ccc.perform(null);
                    }
                    catch (Throwable e) {
                        log.couldNotExecuteCancellationLocally(e.getLocalizedMessage());
                    }
                } else {
                    DefaultExecutorService.this.rpc.invokeRemotely(Collections.singletonList(this.getExecutionTarget()), (ReplicableCommand)ccc, DefaultExecutorService.this.rpc.getDefaultRpcOptions(true));
                }
                this.cancelled = true;
                this.done = true;
                return this.cancelled;
            }
            return false;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            V result = null;
            try {
                result = this.innerGet(0L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new ExecutionException(e);
            }
            finally {
                this.done = true;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                V v = this.innerGet(timeout, unit);
                return v;
            }
            finally {
                this.done = true;
            }
        }

        private V innerGet(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException, InterruptedException {
            V response;
            if (this.isCancelled()) {
                throw new CancellationException("Task already cancelled");
            }
            long timeoutNanos = this.computeTimeoutNanos(timeout, unit);
            long endNanos = DefaultExecutorService.this.timeService.expectedEndTime(timeoutNanos, TimeUnit.NANOSECONDS);
            try {
                response = timeoutNanos > 0L ? this.retrieveResult(this.f.get(timeoutNanos, TimeUnit.NANOSECONDS)) : this.retrieveResult(this.f.get());
            }
            catch (TimeoutException te) {
                throw te;
            }
            catch (Exception e) {
                boolean canFailover;
                long remainingNanos;
                long l = remainingNanos = timeoutNanos > 0L ? DefaultExecutorService.this.timeService.remainingTime(endNanos, TimeUnit.NANOSECONDS) : timeoutNanos;
                if (timeoutNanos > 0L && remainingNanos <= 0L) {
                    if (trace) {
                        log.tracef("Distributed task timed out, throwing a TimeoutException and ignoring exception", e);
                    }
                    throw new TimeoutException();
                }
                boolean bl = canFailover = this.failedOverCount++ < this.getOwningTask().getTaskFailoverPolicy().maxFailoverAttempts();
                if (canFailover) {
                    try {
                        response = this.failoverExecution(e, timeoutNanos, TimeUnit.NANOSECONDS);
                    }
                    catch (Exception failedOver) {
                        throw this.wrapIntoExecutionException(failedOver);
                    }
                }
                throw this.wrapIntoExecutionException(e);
            }
            return response;
        }

        private long computeTimeoutNanos(long timeout, TimeUnit unit) {
            long taskTimeout = TimeUnit.MILLISECONDS.toNanos(this.getOwningTask().timeout());
            long futureTimeout = TimeUnit.NANOSECONDS.convert(timeout, unit);
            long actualTimeout = taskTimeout > 0L && futureTimeout > 0L ? Math.min(taskTimeout, futureTimeout) : Math.max(taskTimeout, futureTimeout);
            return actualTimeout;
        }

        protected ExecutionException wrapIntoExecutionException(Exception e) {
            if (e instanceof ExecutionException) {
                return (ExecutionException)e;
            }
            return new ExecutionException(e);
        }

        private V failoverExecution(final Exception cause, long timeout, TimeUnit unit) throws Exception {
            final List<Address> executionCandidates = DefaultExecutorService.this.executionCandidates(this.getOwningTask());
            FailoverContext fc = new FailoverContext(){

                @Override
                public <K> List<K> inputKeys() {
                    return DistributedTaskPart.this.getInputKeys();
                }

                @Override
                public Address executionFailureLocation() {
                    return DistributedTaskPart.this.getExecutionTarget();
                }

                @Override
                public List<Address> executionCandidates() {
                    return executionCandidates;
                }

                @Override
                public Throwable cause() {
                    return cause;
                }
            };
            Address target = this.getOwningTask().getTaskFailoverPolicy().failover(fc);
            DistributedTaskPart<V> part = DefaultExecutorService.this.createDistributedTaskPart(this.owningTask, this.distCommand, this.getInputKeys(), target, this.failedOverCount);
            part.execute();
            return part.get(timeout, unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyDone() {
            this.listenerLock.writeLock().lock();
            try {
                this.callCompleted = true;
                for (FutureListener<V> l : this.listeners) {
                    l.futureDone(this);
                }
            }
            finally {
                this.listenerLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NotifyingFuture<V> attachListener(FutureListener<V> listener) {
            this.listenerLock.readLock().lock();
            try {
                if (!this.callCompleted) {
                    this.listeners.add(listener);
                }
                if (this.callCompleted) {
                    listener.futureDone(this);
                }
                DistributedTaskPart distributedTaskPart = this;
                return distributedTaskPart;
            }
            finally {
                this.listenerLock.readLock().unlock();
            }
        }

        @Override
        public void setNetworkFuture(Future<V> future) {
            this.f = future;
        }

        V retrieveResult(Object response) throws Exception {
            Object result = null;
            if (response instanceof Exception) {
                throw (Exception)response;
            }
            if (response == null || !(response instanceof Map)) {
                throw new IllegalStateException("Invalid response received " + response);
            }
            Map mapResult = (Map)response;
            if (mapResult.size() == 1) {
                for (Map.Entry e : mapResult.entrySet()) {
                    Response value = (Response)e.getValue();
                    if (!(value instanceof SuccessfulResponse)) continue;
                    result = ((SuccessfulResponse)value).getResponseValue();
                }
            } else {
                throw new IllegalStateException("Invalid response " + response);
            }
            return (V)result;
        }

        public void execute() {
            if (this.isLocalNodeExecutionTarget()) {
                this.invokeLocally();
            } else {
                if (trace) {
                    log.tracef("Sending %s to remote execution at node %s", this.f, this.getExecutionTarget());
                }
                try {
                    DefaultExecutorService.this.rpc.invokeRemotelyInFuture(Collections.singletonList(this.getExecutionTarget()), this.getCommand(), DefaultExecutorService.this.rpc.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS).timeout(this.getOwningTask().timeout(), TimeUnit.MILLISECONDS).build(), (NotifyingNotifiableFuture<Object>)this);
                }
                catch (Throwable e) {
                    log.remoteExecutionFailed(this.getExecutionTarget(), e);
                }
            }
        }

        protected void invokeLocally() {
            log.debugf("Sending %s to self", this);
            try {
                Callable<Object> call = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return this.doLocalInvoke();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private Object doLocalInvoke() {
                        Object result = null;
                        DistributedTaskPart.this.getCommand().init(DefaultExecutorService.this.cache);
                        DistributedTaskLifecycleService lifecycle = DistributedTaskLifecycleService.getInstance();
                        try {
                            lifecycle.onPreExecute(DistributedTaskPart.this.getCommand().getCallable(), DefaultExecutorService.this.cache);
                            DefaultExecutorService.this.cancellationService.register(Thread.currentThread(), DistributedTaskPart.this.getCommand().getUUID());
                            result = DistributedTaskPart.this.getCommand().perform(null);
                            Map<Address, SuccessfulResponse> map = Collections.singletonMap(DefaultExecutorService.this.getAddress(), SuccessfulResponse.create(result));
                            return map;
                        }
                        catch (Throwable e) {
                            Throwable throwable = e;
                            return throwable;
                        }
                        finally {
                            lifecycle.onPostExecute(DistributedTaskPart.this.getCommand().getCallable());
                            DefaultExecutorService.this.cancellationService.unregister(DistributedTaskPart.this.getCommand().getUUID());
                            DistributedTaskPart.this.notifyDone();
                        }
                    }
                };
                this.setNetworkFuture(DefaultExecutorService.this.localExecutorService.submit(call));
            }
            catch (Throwable e1) {
                log.localExecutionFailed(e1);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.callCompleted ? 1231 : 1237);
            result = 31 * result + (this.distCommand == null ? 0 : this.distCommand.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DistributedTaskPart)) {
                return false;
            }
            DistributedTaskPart other = (DistributedTaskPart)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.callCompleted != other.callCompleted) {
                return false;
            }
            return !(this.distCommand == null ? other.distCommand != null : !this.distCommand.equals(other.distCommand));
        }

        @Override
        public void run() {
        }

        private DefaultExecutorService getOuterType() {
            return DefaultExecutorService.this;
        }
    }

    private class DefaultDistributedTaskBuilder<T>
    implements DistributedTaskBuilder<T>,
    DistributedTask<T> {
        private Callable<T> callable;
        private long timeout;
        private DistributedTaskExecutionPolicy executionPolicy = DistributedTaskExecutionPolicy.ALL;
        private DistributedTaskFailoverPolicy failoverPolicy = NO_FAILOVER;

        public DefaultDistributedTaskBuilder(long taskTimeout) {
            this.timeout = taskTimeout;
        }

        @Override
        public DistributedTaskBuilder<T> callable(Callable<T> callable) {
            if (callable == null) {
                throw new IllegalArgumentException("Callable cannot be null");
            }
            this.callable = callable;
            return this;
        }

        @Override
        public DistributedTaskBuilder<T> timeout(long t, TimeUnit tu) {
            this.timeout = TimeUnit.MILLISECONDS.convert(t, tu);
            return this;
        }

        @Override
        public DistributedTaskBuilder<T> executionPolicy(DistributedTaskExecutionPolicy policy) {
            if (policy == null) {
                throw new IllegalArgumentException("DistributedTaskExecutionPolicy cannot be null");
            }
            this.executionPolicy = policy;
            return this;
        }

        @Override
        public DistributedTaskBuilder<T> failoverPolicy(DistributedTaskFailoverPolicy policy) {
            this.failoverPolicy = policy == null ? NO_FAILOVER : policy;
            return this;
        }

        @Override
        public DistributedTask<T> build() {
            DefaultDistributedTaskBuilder<T> task = new DefaultDistributedTaskBuilder<T>(this.timeout);
            task.callable(this.callable);
            task.executionPolicy(this.executionPolicy);
            task.failoverPolicy(this.failoverPolicy);
            return task;
        }

        @Override
        public long timeout() {
            return this.timeout;
        }

        @Override
        public DistributedTaskExecutionPolicy getTaskExecutionPolicy() {
            return this.executionPolicy;
        }

        @Override
        public DistributedTaskFailoverPolicy getTaskFailoverPolicy() {
            return this.failoverPolicy;
        }

        @Override
        public Callable<T> getCallable() {
            return this.callable;
        }
    }

    static interface NodeFilter {
        public boolean include(TopologyAwareAddress var1, TopologyAwareAddress var2);
    }

    private static class NoTaskFailoverPolicy
    implements DistributedTaskFailoverPolicy {
        @Override
        public Address failover(FailoverContext fc) {
            return fc.executionFailureLocation();
        }

        @Override
        public int maxFailoverAttempts() {
            return 0;
        }
    }

    private static class RandomNodeTaskFailoverPolicy
    implements DistributedTaskFailoverPolicy {
        @Override
        public Address failover(FailoverContext fc) {
            return this.randomNode(fc.executionCandidates(), fc.executionFailureLocation());
        }

        protected Address randomNode(List<Address> candidates, Address failedExecutionLocation) {
            Random r = new Random();
            candidates.remove(failedExecutionLocation);
            if (candidates.isEmpty()) {
                throw new IllegalStateException("There are no candidates for failover: " + candidates);
            }
            int tIndex = r.nextInt(candidates.size());
            return candidates.get(tIndex);
        }

        @Override
        public int maxFailoverAttempts() {
            return 1;
        }
    }
}

