/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.Cache;
import org.infinispan.io.FileChunkMapper;
import org.infinispan.io.GridFile;

public class GridInputStream
extends InputStream {
    private int index = 0;
    private int localIndex = 0;
    private byte[] currentBuffer = null;
    private int fileSize;
    private boolean closed = false;
    private FileChunkMapper fileChunkMapper;

    GridInputStream(GridFile file, Cache<String, byte[]> cache) {
        this.fileChunkMapper = new FileChunkMapper(file, cache);
        this.fileSize = (int)file.length();
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.isEndReached()) {
            return -1;
        }
        if (this.getBytesRemainingInChunk() == 0) {
            this.fetchChunk();
        }
        int retval = 0xFF & this.currentBuffer[this.localIndex++];
        ++this.index;
        return retval;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        int totalBytesRead = 0;
        while (len > 0) {
            int bytesRead = this.readFromChunk(b, off, len);
            if (bytesRead == -1) {
                return totalBytesRead > 0 ? totalBytesRead : -1;
            }
            off += bytesRead;
            len -= bytesRead;
            totalBytesRead += bytesRead;
        }
        return totalBytesRead;
    }

    private int readFromChunk(byte[] b, int off, int len) {
        if (this.isEndReached()) {
            return -1;
        }
        int remaining = this.getBytesRemainingInChunk();
        if (remaining == 0) {
            this.fetchChunk();
            remaining = this.getBytesRemainingInChunk();
        }
        int bytesToRead = Math.min(len, remaining);
        System.arraycopy(this.currentBuffer, this.localIndex, b, off, bytesToRead);
        this.localIndex += bytesToRead;
        this.index += bytesToRead;
        return bytesToRead;
    }

    @Override
    public long skip(long len) throws IOException {
        this.checkClosed();
        if (len <= 0L) {
            return 0L;
        }
        int bytesToSkip = Math.min((int)len, this.getBytesRemainingInStream());
        this.index += bytesToSkip;
        if (bytesToSkip <= this.getBytesRemainingInChunk()) {
            this.localIndex += bytesToSkip;
        } else {
            this.fetchChunk();
            this.localIndex = this.index % this.getChunkSize();
        }
        return bytesToSkip;
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        return this.getBytesRemainingInChunk();
    }

    @Override
    public void close() throws IOException {
        this.index = 0;
        this.localIndex = 0;
        this.closed = true;
    }

    private boolean isEndReached() {
        return this.index == this.fileSize;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
    }

    private int getBytesRemainingInChunk() {
        return this.currentBuffer == null ? 0 : this.currentBuffer.length - this.localIndex;
    }

    private int getBytesRemainingInStream() {
        return this.fileSize - this.index;
    }

    private void fetchChunk() {
        this.currentBuffer = this.fileChunkMapper.fetchChunk(this.getChunkNumber());
        this.localIndex = 0;
    }

    private int getChunkNumber() {
        return this.index / this.getChunkSize();
    }

    private int getChunkSize() {
        return this.fileChunkMapper.getChunkSize();
    }
}

