/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.Util;

public final class EmbeddedMetadata
implements Metadata {
    private final long lifespan;
    private final long maxIdle;
    private final EntryVersion version;

    private EmbeddedMetadata(long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit, EntryVersion version) {
        this.lifespan = lifespanUnit.toMillis(lifespan);
        this.maxIdle = maxIdleUnit.toMillis(maxIdle);
        this.version = version;
    }

    @Override
    public long lifespan() {
        return this.lifespan;
    }

    @Override
    public long maxIdle() {
        return this.maxIdle;
    }

    @Override
    public EntryVersion version() {
        return this.version;
    }

    @Override
    public Metadata.Builder builder() {
        return new Builder().lifespan(this.lifespan).maxIdle(this.lifespan).version(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedMetadata that = (EmbeddedMetadata)o;
        if (this.lifespan != that.lifespan) {
            return false;
        }
        if (this.maxIdle != that.maxIdle) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = (int)(this.lifespan ^ this.lifespan >>> 32);
        result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EmbeddedMetadata{lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + ", version=" + this.version + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<EmbeddedMetadata> {
        @Override
        public Set<Class<? extends EmbeddedMetadata>> getTypeClasses() {
            return Util.asSet(EmbeddedMetadata.class);
        }

        @Override
        public Integer getId() {
            return 98;
        }

        @Override
        public void writeObject(ObjectOutput output, EmbeddedMetadata object) throws IOException {
            output.writeLong(object.lifespan);
            output.writeLong(object.maxIdle);
            output.writeObject(object.version);
        }

        @Override
        public EmbeddedMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            long lifespan = input.readLong();
            long maxIdle = input.readLong();
            EntryVersion version = (EntryVersion)input.readObject();
            return new EmbeddedMetadata(lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS, version);
        }
    }

    public static final class Builder
    implements Metadata.Builder {
        private long lifespan = -1L;
        private TimeUnit lifespanUnit = TimeUnit.MILLISECONDS;
        private long maxIdle = -1L;
        private TimeUnit maxIdleUnit = TimeUnit.MILLISECONDS;
        private EntryVersion version;

        @Override
        public Metadata.Builder lifespan(long time, TimeUnit unit) {
            this.lifespan = time;
            this.lifespanUnit = unit;
            return this;
        }

        @Override
        public Metadata.Builder lifespan(long time) {
            return this.lifespan(time, TimeUnit.MILLISECONDS);
        }

        @Override
        public Metadata.Builder maxIdle(long time, TimeUnit unit) {
            this.maxIdle = time;
            this.maxIdleUnit = unit;
            return this;
        }

        @Override
        public Metadata.Builder maxIdle(long time) {
            return this.maxIdle(time, TimeUnit.MILLISECONDS);
        }

        @Override
        public Metadata.Builder version(EntryVersion version) {
            this.version = version;
            return this;
        }

        @Override
        public Metadata build() {
            return new EmbeddedMetadata(this.lifespan, this.lifespanUnit, this.maxIdle, this.maxIdleUnit, this.version);
        }
    }
}

